package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState
import com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition
import com.xebialabs.deployit.engine.spi.execution.{NonRemotableExecutionStateListener, StepExecutionStateEvent, TaskExecutionStateEvent}
import com.xebialabs.deployit.engine.tasker.TaskId
import com.xebialabs.deployit.script.SpringBindings
import com.xebialabs.deployit.task.archive.TaskArchive
import grizzled.slf4j.Logging

class RollbackCompletedListener(taskId: TaskId) extends NonRemotableExecutionStateListener with Logging {

  @transient private lazy val taskArchive = SpringBindings.bindings.get().get("taskArchive")
    .map(_.asInstanceOf[TaskArchive]).orNull

  override def taskStateChanged(event: TaskExecutionStateEvent): Unit = {
    if (checkTransition(event, TaskExecutionState.EXECUTING, TaskExecutionState.EXECUTED)) {
      logger.info(s"Updating rollback status of task: [${event.task.getId}]")
      taskArchive.markTaskAsRolledBack(taskId)
    }
  }

  override def stepStateChanged(event: StepExecutionStateEvent): Unit = {}
}
