package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.PipedPlanner.{PlanTransformer, TransformerContext}
import com.xebialabs.deployit.deployment.planner.PlanSugar._
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener
import com.xebialabs.deployit.plugin.api.deployment.specification.{DeltaSpecification, DeltaSpecificationWithDependencies}
import com.xebialabs.deployit.plugin.api.flow.Step

import scala.jdk.CollectionConverters._

class RepositoryUpdateStepPlanner extends PlanTransformer with PlanSugar {
  override def transform(context: TransformerContext): PhasedPlan = {
    val repositoryStep = new StepPlan(
      s"Register changes for ${allApplicationNames(context.spec)}",
      List[Step](new RepositoryUpdateStep(spec = context.spec, contributors = List(new ContainersToEnvironmentContributor))).asJavaCollection,
      List[ExecutionStateListener]().asJava
    )
    val repositoryPlan = new PlanPhase(repositoryStep, context.plan.getDescription, List().asJava, true)
    context.plan.copy(phases = (context.plan.phases.asScala :+ repositoryPlan).asJava)
  }

  private def allApplicationNames(specificationWithDependencies: DeltaSpecificationWithDependencies) =
    specificationWithDependencies
      .getAllDeltaSpecifications
      .asScala
      .toList
      .map(deployedApplication)
      .map(_.getName)
      .mkString(", ")

  private def deployedApplication(spec: DeltaSpecification) =
    Option(spec.getDeployedApplication).getOrElse(spec.getPreviousDeployedApplication)
}
