package com.xebialabs.deployit.deployment.planner

import java.io.Writer
import java.util.{List => JList}

import com.xebialabs.deployit.deployment.planner.StepPlan.Checkpoint
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener

import scala.jdk.CollectionConverters._

class PhasedPlan(val phases: JList[PlanPhase],
                 listeners: JList[ExecutionStateListener]) extends Plan("", listeners) {

  override def writePlan(writer: Writer): Writer = {
    writer.append("# [Phased plan] " + this.getDescription + "\n")
    phases.asScala.foreach(_.writePlan(writer))
    writer
  }

  override def findCheckpoints(): JList[Checkpoint] = phases.asScala.flatMap(_.findCheckpoints().asScala).asJava
}
