package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.deployment.orchestrator.DescriptionHelper._
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.engine.spi.orchestration.{Orchestration, Orchestrator}
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies

import scala.jdk.CollectionConverters._

@Orchestrator.Metadata (name = "parallel-by-dependency", description = "The Parallel by dependency orchestrator")
class ParallelByDependencyOrchestrator extends Orchestrator {

  override def orchestrate(specs: DeltaSpecificationWithDependencies): Orchestration = {
    val parallels = specs
      .getAllGroupedDeltaSpecifications
      .asScala
      .map[Orchestration](group => parallel(
        getDescriptionForSpecs(group),
        group.asScala.map[Orchestration](spec => interleaved(getDescriptionForSpec(spec), spec.getDeltas)).asJava
      )).toList
    serial(getDescriptionForSpecWithDependencies(specs), parallels.asJava)
  }

}
