package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.PipedPlanner.{PlanTransformer, TransformerContext}
import com.xebialabs.deployit.deployment.planner.PlanSugar._
import com.xebialabs.deployit.deployment.planner.SizeChunkingPlanner.threshold
import com.xebialabs.deployit.deployment.planner.StepPlan.StepWithPlanningInfo

import scala.jdk.CollectionConverters._
import scala.collection.mutable

object SizeChunkingPlanner {
  val threshold: Int = 100
}

class SizeChunkingPlanner extends PlanTransformer with PlanSugar {
  def transform(context: TransformerContext): PhasedPlan = chunkBySize(context.plan)

  def chunkBySize(complexPlan: Plan): PhasedPlan = complexPlan match {
    case phasedPlan: PhasedPlan => chunkBySize(phasedPlan)
    case planPhase: PlanPhase => new PhasedPlan(List(chunkBySize(planPhase)).asJava, planPhase.getListeners)
    case plan: ExecutablePlan => new PhasedPlan(List(new PlanPhase(chunkBySize(plan), plan.getDescription, plan.getListeners)).asJava, plan.getListeners)
  }

  def chunkBySize(plan: ExecutablePlan): ExecutablePlan = plan match {
    case cp: CompositePlan => cp.copy(subPlans = cp.getSubPlans.asScala.map(chunkBySize).asJava)
    case stp: StepPlan if stp.getStepsSize > threshold => stp.toSerial(subPlans = chunkBySize(stp).asJava)
    case stp: StepPlan => stp
  }

  def chunkBySize(phasedPlan: PhasedPlan): PhasedPlan = phasedPlan.copy(phases = phasedPlan.phases.asScala.map(chunkBySize).asJava)

  def chunkBySize(planPhase: PlanPhase): PlanPhase = planPhase.copy(plan = chunkBySize(planPhase.plan))

  def chunkBySize(plan: StepPlan): List[ExecutablePlan] =
    plan
      .getStepsWithPlanningInfo
      .asScala
      .grouped(threshold)
      .zipWithIndex
      .map { case (steps, order) => createStepPlanForSizedChunks(order, steps, plan) }
      .toList

  def createStepPlanForSizedChunks(order: Int, steps: mutable.Buffer[StepWithPlanningInfo], plan: StepPlan): StepPlan = {
    def label(i: Int, p: StepPlan): String = s"Step ${1 + threshold * i} to ${Math.min(threshold * (i + 1), p.getStepsSize)}"
    plan.copy(label(order, plan), steps.asJava, findCheckpoints(steps, plan.getCheckpoints))
  }

}
