package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.booter.local.utils.ReflectionUtils._
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, Operation}
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.rules.Scope
import com.xebialabs.deployit.plugin.api.udm.Deployed

import java.lang.reflect.{InvocationTargetException, Method}

object JavaDeployedInvokerRule {
  private def buildName(deployedType: Type, typeContributor: Method, operation: Operation) = s"$deployedType.${typeContributor.getName}_$operation"
}

import com.xebialabs.deployit.deployment.rules.JavaDeployedInvokerRule._

class JavaDeployedInvokerRule(val deployedType: Type, typeContributor: Method, operation: Operation) extends Rule(buildName(deployedType, typeContributor, operation), Scope.DEPLOYED) {

  override def canFire(delta: AnyRef, context: RulePlanningContext): Boolean = delta match {
    case d: Delta => d.getOperation == operation && getDeployed(d).getType.equals(deployedType)
    case _ => false
  }

  override def doFire(delta: AnyRef, context: RulePlanningContext): Unit = {
    val compatibleContext = context.backwardCompatible
    val deployed = getDeployed(delta.asInstanceOf[Delta])
    debug(s"Invoking rule [$getName] for deployed [$deployed]")
    try {
      if (typeContributor.getParameterTypes.length == 2) {
        typeContributor.invoke(deployed, compatibleContext, delta)
      } else {
        typeContributor.invoke(deployed, compatibleContext)
      }
    } catch {
      case e: InvocationTargetException => throw handleInvocationTargetException(e, "")
      case e: Exception => throw e
    }
  }

  private def getDeployed(delta: Delta): Deployed[_, _] = if (delta.getOperation == Operation.DESTROY) delta.getPrevious else delta.getDeployed
}
