package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.StepPlan.StepWithPlanningInfo
import com.xebialabs.deployit.engine.api.execution.StepState
import com.xebialabs.deployit.engine.tasker.BlockBuilders._
import com.xebialabs.deployit.engine.tasker.Phase.PhaseBuilder
import com.xebialabs.deployit.engine.tasker.{ExecutableBlockBuilder, PhaseContainerBuilder, TaskStep}
import com.xebialabs.deployit.plugin.api.flow.PreviewStep

import scala.jdk.CollectionConverters._

object Plans {
  def toBlockBuilder(plan: PhasedPlan): PhaseContainerBuilder =
    phases(plan.getDescription, plan.phases.asScala.map(toPhaseBuilder).toList)

  def toPhaseBuilder(planPhase: PlanPhase): PhaseBuilder = {
    val executableBlockBuilder = toExecutableBlockBuilder(planPhase.plan)
    val phaseBuilder: PhaseBuilder = phase(planPhase.getDescription, planPhase.getDescription, executableBlockBuilder)
    if (planPhase.alwaysExecuted) {
      phaseBuilder.asAlwaysExecuted
    } else {
      phaseBuilder
    }
  }

  def toExecutableBlockBuilder(plan: ExecutablePlan): ExecutableBlockBuilder = plan match {
    case sp: SerialPlan => serial(sp.getDescription, sp.satellite, sp.getSubPlans.asScala.map(toExecutableBlockBuilder).asJava)
    case pp: ParallelPlan => parallel(pp.getDescription, pp.satellite, pp.getSubPlans.asScala.map(toExecutableBlockBuilder).asJava)
    case stp: StepPlan => steps(stp.getDescription, Option(stp.satellite), asTaskSteps(stp))
  }

  private def asTaskSteps(plan: StepPlan): List[StepState] = {
    plan.getStepsWithPlanningInfo.asScala.zipWithIndex.map { case (swpi: StepWithPlanningInfo, index: Int) =>
      val taskStep: TaskStep = new TaskStep(swpi.getStep)
      var i: Int = 0
      plan.getCheckpoints.asScala.filter(_.getStep == swpi.getStep).map(_.getId).foreach { id =>
        taskStep.getMetadata.put(s"checkpointId_$i", id)
        i += 1
      }
      taskStep.getMetadata.put("index", Integer.toString(index));
      taskStep.getMetadata.put("order", Integer.toString(swpi.getStep.getOrder))
      taskStep.getMetadata.put("previewAvailable", swpi.getStep.isInstanceOf[PreviewStep].toString)
      taskStep.getMetadata.put("rule", swpi.getRule)
      swpi.getDeltas.asScala.zipWithIndex.foreach { case (d, i) =>
        taskStep.getMetadata.put(s"deployed_$i", Option(d.getDeployed).getOrElse(d.getPrevious).getId)
        taskStep.getMetadata.put(s"applicationType_$i", Option(d.getDeployed).getOrElse(d.getPrevious).getDeployable.getType.toString)
        taskStep.getMetadata.put(s"infrastructureType_$i", Option(d.getDeployed).getOrElse(d.getPrevious).getContainer.getType.toString)
      }
      taskStep
    }.toList
  }
}
