package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.unmodifiableList;

@SuppressWarnings("serial")
public class DefaultDeltaSpecification implements DeltaSpecification, Serializable {

    private boolean rollback;
    private Operation operation;
    private DeployedApplication previousDeployedApplication;
    private DeployedApplication deployedApplication;
    private List<Delta> deltas;

    public DefaultDeltaSpecification(Operation operation, DeployedApplication previousDeployedApplication, DeployedApplication deployedApplication, List<Delta> deltas, boolean rollback) {
        this(operation, previousDeployedApplication, deployedApplication, deltas);
        this.rollback = rollback;
    }

    public DefaultDeltaSpecification(Operation operation, DeployedApplication previousDeployedApplication, DeployedApplication deployedApplication, List<Delta> deltas) {
        this.operation = operation;
        this.previousDeployedApplication = previousDeployedApplication;
        this.deployedApplication = deployedApplication;
        ArrayList<Delta> deltas1 = newArrayList(deltas);
        Collections.sort(deltas1, (Delta delta, Delta delta1) -> {
            Deployed d1 = delta.getOperation() != Operation.DESTROY ? delta.getDeployed() : delta.getPrevious();
            Deployed d2 = delta1.getOperation() != Operation.DESTROY ? delta1.getDeployed() : delta1.getPrevious();
            return d1.getName().compareTo(d2.getName());
        });
        this.deltas = unmodifiableList(deltas1);
    }

    @Override
    public Operation getOperation() {
        return operation;
    }

    @Override
    public DeployedApplication getPreviousDeployedApplication() {
        return previousDeployedApplication;
    }


    @Override
    public DeployedApplication getDeployedApplication() {
        return deployedApplication;
    }

    @Override
    public List<Delta> getDeltas() {
        return deltas;
    }

    public boolean isRollback() {
        return rollback;
    }
}
