package com.xebialabs.deployit.deployment
package orchestrator

import com.xebialabs.deployit.deployment.orchestrator.DescriptionHelper._
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.engine.spi.orchestration.{Orchestration, Orchestrator}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecificationWithDependencies, Operation}
import com.xebialabs.xlplatform._

import scala.jdk.CollectionConverters._

trait ContainerOrchestratorBase extends OrchestratorUtil {
  def getOrchestrations(deltas: List[Delta], operation: Operation): List[Orchestration] = {
    val orderForOperation = getOrderForString(operation)
    val deltasByContainer = deltas.groupBy(_.correctDeployed.getContainer)
    deltasByContainer
      .toList
      .sortBy{ case (container, _) => container.getName }(orderForOperation)
      .map { case (container, ds) => interleaved(getDescriptionForContainer(operation, container), ds.asJava) }
  }
}

@Orchestrator.Metadata (name = "sequential-by-container", description = "The sequential by container orchestrator")
class SequentialByContainerOrchestrator extends Orchestrator with ContainerOrchestratorBase {
  override def orchestrate(specificationWithDependencies: DeltaSpecificationWithDependencies): Orchestration = {
    serial(
      getDescriptionForSpecWithDependencies(specificationWithDependencies),
      getOrchestrations(mergeDeltas(specificationWithDependencies), getMainDeltaSpecification(specificationWithDependencies).getOperation).asJava
    )
  }
}

@Orchestrator.Metadata (name = "parallel-by-container", description = "The parallel by container orchestrator")
class ParallelByContainerOrchestrator extends Orchestrator with ContainerOrchestratorBase {
  override def orchestrate(specificationWithDependencies: DeltaSpecificationWithDependencies): Orchestration = {
    parallel(
      getDescriptionForSpecWithDependencies(specificationWithDependencies),
      getOrchestrations(mergeDeltas(specificationWithDependencies), getMainDeltaSpecification(specificationWithDependencies).getOperation).asJava
    )
  }
}

