package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.plugin.api.flow.Step;

import java.util.Comparator;

import static com.google.common.base.Strings.nullToEmpty;

/**
 * Comparator that sorts {@link com.xebialabs.deployit.plugin.api.deployment.execution.Step} according to their
 * {@link com.xebialabs.deployit.plugin.api.deployment.execution.Step#getOrder()} in an ascending fashion.
 */
class StepComparator implements Comparator<Step> {
    @Override
    public int compare(Step o1, Step o2) {
        int i = o1.getOrder() - o2.getOrder();
        if (i == 0) {
            return nullToEmpty(o1.getDescription()).compareTo(nullToEmpty(o2.getDescription()));
        }
        return i;
    }
}