package com.xebialabs.deployit.deployment.planner;

import java.util.HashMap;

import static com.google.common.collect.Maps.newHashMap;

/**
 * Context that is passed along during the Planning stage of a Deployment. This can be used to
 * store and retrieve attributes to transfer knowledge between multiple Contributors/Processors.
 */

public class GlobalDeploymentPlanningContext {
    private final HashMap<String, Object> attributes = newHashMap();

    /**
     * Returns the global planning context attribute with the given name, or <tt>null</tt> if there is no attribute by that name.
     *
     * @param name
     *            the name of the attribute
     * @return the value of the attribute, or <tt>null</tt> if there is no attribute by that name.
     */
    public Object getAttribute(String name) {
        return attributes.get(name);
    }

    /**
     * Stores an attribute in the global planning context. This attribute will be available while the deployment plan is being created.
     *
     * @param name
     *            the name of the attribute
     * @param value
     *            the value of the attribute
     */
    public void setAttribute(String name, Object value) {
        attributes.put(name, value);
    }
}