package com.xebialabs.deployit.deployment.rules

import java.io.InputStream
import java.lang.Iterable
import java.util

import com.xebialabs.deployit.deployment.planner.{DefaultDeploymentPlanningContext, GlobalDeploymentPlanningContext, StepPlan}
import com.xebialabs.deployit.deployment.rules.RulePlanningContext._
import com.xebialabs.deployit.deployment.service.ArtifactTransformerFactory
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep
import com.xebialabs.deployit.plugin.api.deployment.planning.{Checkpoint, DeploymentPlanningContext}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification, Operation}
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.services.{ArtifactTransformer, Repository}
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, DeployedApplication}

object RulePlanningContext {
  def apply(spec: DeltaSpecification, stepRegistry: StepRegistry, readOnlyRepository: Repository, artifactTransformerFactory: ArtifactTransformerFactory, plan: StepPlan,backwardsCompatible: Boolean = false, globalContext: GlobalDeploymentPlanningContext) = {
    new RulePlanningContext(spec, readOnlyRepository, artifactTransformerFactory, plan, backwardsCompatible, globalContext) {
      override def getStepRegistry: StepRegistry = stepRegistry
    }
  }

  private[RulePlanningContext] def whichDeployedApplication(deltaSpecification: DeltaSpecification): DeployedApplication = deltaSpecification.getOperation match {
    case Operation.DESTROY => null
    case _ => deltaSpecification.getDeployedApplication
  }
}

sealed abstract class RulePlanningContext(deltaSpecification: DeltaSpecification,
                                          readOnlyRepository: Repository,
                                          artifactTransformerFactory: ArtifactTransformerFactory,
                                          plan: StepPlan,
                                          wrappedContext: DeploymentPlanningContext,
                                          backwardsCompatible: Boolean = false,
                                          globalContext: GlobalDeploymentPlanningContext) extends ScalaJavaBridgeDeploymentPlanningContext {


  def this(deltaSpecification: DeltaSpecification, repo: Repository, artifactTransformerFactory: ArtifactTransformerFactory, plan: StepPlan,backwardsCompatible: Boolean , globalContext: GlobalDeploymentPlanningContext) =
    this(deltaSpecification, repo, artifactTransformerFactory, plan,
      new DefaultDeploymentPlanningContext(whichDeployedApplication(deltaSpecification), deltaSpecification.getPreviousDeployedApplication,
        repo, artifactTransformerFactory, plan, deltaSpecification.isRollback()), backwardsCompatible,  globalContext)

  def getStepRegistry: StepRegistry

  def backwardCompatible: RulePlanningContext = {
    new RulePlanningContext(deltaSpecification, readOnlyRepository, artifactTransformerFactory, plan, wrappedContext, true, globalContext) {
      override def getStepRegistry: StepRegistry = RulePlanningContext.this.getStepRegistry
    }
  }

  override def getDeployedApplication: DeployedApplication = deltaSpecification.getOperation match {
    case Operation.DESTROY if backwardsCompatible => getPreviousDeployedApplication
    case _ => wrappedContext.getDeployedApplication
  }

  def getGlobalDeploymentPlanningContext(): GlobalDeploymentPlanningContext = globalContext

  override def addStepWithCheckpoint(step: Step, checkpoint: Checkpoint): Unit = wrappedContext.addStepWithCheckpoint(step, checkpoint)

  override def addStepWithCheckpoint(step: Step, delta: Delta): Unit = wrappedContext.addStepWithCheckpoint(step, delta)

  override def addStepWithCheckpoint(step: Step, delta: Delta, overrideOperation: Operation): Unit = wrappedContext.addStepWithCheckpoint(step, delta, overrideOperation)

  override def addStepWithCheckpoint(step: Step, deltas: Iterable[Delta]): Unit = wrappedContext.addStepWithCheckpoint(step, deltas)

  override def getAttribute(name: String): AnyRef = wrappedContext.getAttribute(name)

  override def getPreviousDeployedApplication: DeployedApplication = wrappedContext.getPreviousDeployedApplication

  override def setAttribute(name: String, value: scala.Any): Unit = wrappedContext.setAttribute(name, value)

  override def addCheckpoint(step: Step, checkpoint: Checkpoint): Unit = wrappedContext.addCheckpoint(step, checkpoint)

  override def addCheckpoint(step: Step, delta: Delta): Unit = wrappedContext.addCheckpoint(step, delta)

  override def addCheckpoint(step: Step, delta: Delta, overrideOperation: Operation): Unit = wrappedContext.addCheckpoint(step, delta, overrideOperation)

  override def addCheckpoint(step: Step, deltas: Iterable[Delta]): Unit = wrappedContext.addCheckpoint(step, deltas)

  override def addSteps(steps: util.Collection[DeploymentStep]): Unit = wrappedContext.addSteps(steps)

  override def addSteps(steps: Iterable[Step]): Unit = wrappedContext.addSteps(steps)

  override def getRepository: Repository = wrappedContext.getRepository

  override def addStep(step: DeploymentStep): Unit = wrappedContext.addStep(step)

  override def addStep(step: Step): Unit = wrappedContext.addStep(step)

  override def isRollback: Boolean = wrappedContext.isRollback

  override def patch(content: InputStream, ci: ConfigurationItem): InputStream = wrappedContext.patch(content, ci)

  override def patch(content: String, ci: ConfigurationItem): String = wrappedContext.patch(content, ci)

  override def getArtifactTransformer(transformerName: String): ArtifactTransformer = wrappedContext.getArtifactTransformer(transformerName)

}