package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification, DeltaSpecificationWithDependencies, Operation}

import scala.jdk.CollectionConverters._

trait OrchestratorUtil {

  protected def getOrderForString(op: Operation): Ordering[String] = op match {
    case Operation.DESTROY => Ordering.String.reverse
    case _ => Ordering.String
  }

  protected def getOrderForInt(op: Operation): Ordering[Int] = op match {
    case Operation.DESTROY => Ordering.Int.reverse
    case _ => Ordering.Int
  }

  protected def getMainDeltaSpecification(specs: DeltaSpecificationWithDependencies): DeltaSpecification =
    specs.getAllDeltaSpecifications.asScala.lastOption.orNull

  protected def mergeDeltas(specificationWithDependencies: DeltaSpecificationWithDependencies): List[Delta] =
    specificationWithDependencies.getAllDeltaSpecifications.asScala.flatMap(_.getDeltas.asScala).toList

}
