
package com.xebialabs.deployit.deployment.orchestrator

import com.xebialabs.deployit.deployment.orchestrator.DescriptionHelper._
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations._
import com.xebialabs.deployit.engine.spi.orchestration.{Orchestration, Orchestrator}
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies

import scala.jdk.CollectionConverters._

@Orchestrator.Metadata (name = "sequential-by-dependency", description = "The sequential by dependency orchestrator")
class DependencyOrchestrator extends Orchestrator {
  override def orchestrate(specificationWithDependencies: DeltaSpecificationWithDependencies): Orchestration = {
    serial(
      getDescriptionForSpecWithDependencies(specificationWithDependencies),
      specificationWithDependencies.getAllDeltaSpecifications.asScala.map(spec => interleaved(getDescriptionForSpec(spec), spec.getDeltas)).toSeq: _*
    )
  }
}
