package com.xebialabs.deployit.deployment.rules

import grizzled.slf4j.Logging

import scala.collection.mutable

class SimpleStepRegistry extends StepRegistry with Logging {

  private final val stepsByName = mutable.Map[String, StepDescriptor]()

  override def register(stepDescriptor: StepDescriptor) = {
    if (stepsByName.isDefinedAt(stepDescriptor.name)) {
      throw new IllegalArgumentException(s"Duplicate step name ${stepDescriptor.name}.")
    }
    stepsByName(stepDescriptor.name) = stepDescriptor
  }

  override def getStepDescriptor(name: String): StepDescriptor = stepsByName.getOrElse(name, throw new IllegalArgumentException(s"Step $name could not be found"))
}
