package com.xebialabs.deployit.deployment.service

import com.xebialabs.deployit.engine.spi.exception.DeployitException
import com.xebialabs.deployit.plugin.api.services.ArtifactTransformer

trait ArtifactTransformerFactory {

  @throws(classOf[ArtifactTransformerNotDefinedException])
  def getArtifactTransformer(artifactTransformerName: String): ArtifactTransformer

}

final case class ArtifactTransformerNotDefinedException(message: String) extends DeployitException(message)