package com.xebialabs.deployit.repository.placeholders

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

trait ResolvedPlaceholderRepository {

  def isPlaceholderEncrypted(key: String, containerPath: String, versionPath: String): Boolean

  def saveResolvedPlaceholders(taskId: String, resolvedPlaceholders: java.util.Set[ResolvedPlaceholder]): Unit
  def archiveResolvedPlaceholder(deployedAppId: String): Unit

  def updatePlaceholderReferencePaths(oldPath: String, newPath: String): Unit
  def markPlaceholderReferenceAsDeleted(ci: ConfigurationItem): Unit
  def markArchivedPlaceholderReferenceAsDeleted(ci: ConfigurationItem, placeholders: List[(String, ResolvedPlaceholderEntry)]): Unit

  def getResolvedPlaceholder(deployedAppId: String): List[(String, ResolvedPlaceholderEntry)]
  def countAllResolvedPlaceholdersForEnvironment(environmentId: String, key: Option[String], value: Option[String], dictionary: Option[String],
                                                 deployedApplication: Option[String], host: Option[String]): Int
  def getResolvedPlaceholdersForEnvironment(environmentId: String, key: Option[String], value: Option[String],
                                            dictionary: Option[String], deployedApplication: Option[String],
                                            host: Option[String], paging: Paging, order: Ordering) : List[ResolvedPlaceholder]

  def countAllResolvedPlaceholdersForContainer(containerId: String, key: Option[String], value: Option[String], dictionary: Option[String],
                                               deployedApplication: Option[String], environment: Option[String]): Int
  def getResolvedPlaceholdersForContainer(containerId: String, key: Option[String], value: Option[String],
                                          dictionary: Option[String], deployedApplication: Option[String],
                                          environment: Option[String], paging: Paging, order: Ordering): List[ResolvedPlaceholder]

  def countAllArchivedResolvedPlaceholdersForEnvironment(environmentId: String, key: Option[String], value: Option[String],
                                                         dictionary: Option[String], deployedApplication: Option[String],
                                                         host: Option[String], taskId: Option[String]): Int
  def getArchivedResolvedPlaceholdersForEnvironment(environmentId: String, key: Option[String], value: Option[String],
                                                    dictionary: Option[String], deployedApplication: Option[String],
                                                    host: Option[String], taskId: Option[String], paging: Paging, order: Ordering) : List[ResolvedPlaceholder]

}

case class ResolvedPlaceholderEntry(isEncrypted: Boolean, key: String, value: String, fullValue: String, containerId: String,
                                    deployedAppId: String, dictionaryId: String, environmentId: String, versionId: String,
                                    containerDeleted: Boolean, dictionaryDeleted: Boolean, environmentDeleted: Boolean)
