package com.xebialabs.deployit.deployment.planner

import java.util.{ArrayList => JArrayList, List => JList}

import com.xebialabs.deployit.deployment.planner.StepPlan.{Checkpoint, StepWithPlanningInfo}
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener
import com.xebialabs.xlplatform.satellite.Satellite

import scala.collection.mutable
import scala.jdk.CollectionConverters._

trait PlanSugar {
  def findCheckpoints(chunk: mutable.Buffer[StepWithPlanningInfo], cp: JList[StepPlan.Checkpoint]): JList[Checkpoint] = {
    val chunkDeltas = chunk.toSet[StepWithPlanningInfo].flatMap(_.getDeltas.asScala)
    cp.asScala.filter(x => chunkDeltas.contains(x.getDelta)).asJava
  }
}

object PlanSugar {

  implicit class CompositePlanCopySugar(val plan: CompositePlan) extends AnyVal {
    def copy(description: String = plan.getDescription,
             subPlans: JList[_ <: ExecutablePlan] = plan.getSubPlans,
             listeners: JList[ExecutionStateListener] = plan.getListeners,
             satellite: Satellite = plan.satellite): CompositePlan = {
      plan match {
        case _: SerialPlan => new SerialPlan(description, subPlans, listeners, satellite)
        case _: ParallelPlan => new ParallelPlan(description, subPlans, listeners, satellite)
        case _ => throw new IllegalArgumentException(s"Unknown composite plan subtype $plan")
      }
    }
  }

  implicit class PlanPhaseCopySugar(val phase: PlanPhase) extends AnyVal {
    def copy(description: String = phase.getDescription,
             plan: ExecutablePlan = phase.plan,
             listeners: JList[ExecutionStateListener] = phase.getListeners): PlanPhase =
      new PlanPhase(plan, description, listeners, phase.alwaysExecuted)
  }

  implicit class PhasedPlanCopySugar(val phasedPlan: PhasedPlan) extends AnyVal {
    def copy(phases: JList[PlanPhase] = phasedPlan.phases,
             listeners: JList[ExecutionStateListener] = phasedPlan.getListeners): PhasedPlan =
      new PhasedPlan(phases, listeners)
  }

  implicit class ExecutableSugar(val plan: ExecutablePlan) extends AnyVal {
    def toSerial(description: String = plan.getDescription,
                 subPlans: JList[ExecutablePlan],
                 listeners: JList[ExecutionStateListener] = plan.getListeners,
                 satellite: Satellite = plan.satellite) =
      new SerialPlan(description, subPlans, listeners, satellite)

    def emptySteps() =
      new StepPlan(
        plan.getDescription,
        new JArrayList[StepWithPlanningInfo](),
        new JArrayList[Checkpoint](),
        plan.getListeners,
        plan.satellite
      )
  }

  implicit class StepPlanSugar(val sp: StepPlan) extends AnyVal {
    def copy(description: String = sp.getDescription,
             steps: JList[StepWithPlanningInfo] = sp.getStepsWithPlanningInfo,
             checkpoints: JList[Checkpoint] = sp.getCheckpoints,
             listeners: JList[ExecutionStateListener] = sp.getListeners,
             satellite: Satellite = sp.satellite): StepPlan =
      new StepPlan(description, steps, checkpoints, listeners, satellite)
  }

}
