package com.xebialabs.deployit.repository.placeholders

import java.util.concurrent.atomic.AtomicReference

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class PlaceholderRepositoryHolder(@Autowired placeholderRepository: PlaceholderRepository,
                                  @Autowired resolvedPlaceholderRepository: ResolvedPlaceholderRepository) {
  PlaceholderRepositoryHolder.placeholderRepository.set(placeholderRepository)
  PlaceholderRepositoryHolder.resolvedPlaceholderRepository.set(resolvedPlaceholderRepository)
}

object PlaceholderRepositoryHolder {
  private val placeholderRepository = new AtomicReference[PlaceholderRepository]
  private val resolvedPlaceholderRepository = new AtomicReference[ResolvedPlaceholderRepository]

  def getPlaceholderRepository: PlaceholderRepository = PlaceholderRepositoryHolder.placeholderRepository.get()

  def getResolvedPlaceholderRepository: ResolvedPlaceholderRepository = PlaceholderRepositoryHolder.resolvedPlaceholderRepository.get()
}
