package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.rules.PlanCreationContext

/**
 * Planner is responsible for building deployment plan based on DeltaSpecification and context
 */
trait Planner {
  /**
   * Build a phased deployment from delta specification
   * @param spec - multi application (application with possible dependencies) delta specification instance
   * @param planCreationContext - context instance
   * @return ready-to-use PhasedPlan instance
   */
  def plan(spec: MultiDeltaSpecification, planCreationContext: PlanCreationContext): PhasedPlan
}
