package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.StepPlan.Checkpoint
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener

import java.io.Writer
import java.util
import java.util.{List => juList}

class PlanPhase(val plan: ExecutablePlan, description: String, listeners: juList[ExecutionStateListener], val alwaysExecuted: Boolean) extends Plan(description, listeners) {

  def this(plan: ExecutablePlan, description: String, listeners: juList[ExecutionStateListener]) = {
    this(plan, description, listeners, false)
  }

  override def writePlan(writer: Writer): Writer = {
    writer.append(s"# [Plan phase] ${this.getDescription}\n")
    plan.writePlan(writer)
  }

  override def findCheckpoints(): util.List[Checkpoint] = {
    plan.findCheckpoints()
  }
}
