package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.xlplatform.satellite.Satellite;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class ParallelPlan extends CompositePlan {

    public ParallelPlan(String description, List<? extends ExecutablePlan> subPlans, List<ExecutionStateListener> listeners) {
        super(description, subPlans, listeners);
    }

    public ParallelPlan(String description, List<? extends ExecutablePlan> subPlans, List<ExecutionStateListener> listeners, Satellite satellite) {
        super(description, subPlans, listeners, satellite);
    }

    @Override
    public Writer writePlan(final Writer writer) {
        PrintWriter out = new PrintWriter(writer);

        boolean first = true;

        writeBlockBoundery(out, 2);
        if (satellite() != null) {
            out.println("# [Parallel (on Satellite " + satellite() + "] " + this.getDescription());
        } else {
            out.println("# [Parallel] " + this.getDescription());
        }
        writeBlockBoundery(out, 2);

        for (Plan subPlan : getSubPlans()) {
            StringWriter singlePlanWriter = new StringWriter();
            if (!first) {
                singlePlanWriter.append("============================================>\n");
            }
            subPlan.writePlan(singlePlanWriter);
            out.append(indent(singlePlanWriter.toString(), 4));

            first = false;
        }

        return writer;
    }
}
