package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.PipedPlanner.{PlanTransformer, TransformerContext}
import com.xebialabs.deployit.deployment.planner.PlanSugar._

import scala.jdk.CollectionConverters._

class SimplifyingDeploymentPlanner extends PlanTransformer with PlanSugar {
  def transform(context: TransformerContext): PhasedPlan =
    context.spec.getAllDeltaSpecifications.asScala.toList match {
      case head :: _ if head.getDeployedApplication.isOptimizePlan => simplify(context.plan)
      case _ => context.plan
    }

  def simplify(complexPlan: Plan): PhasedPlan = complexPlan match {
    case phasedPlan: PhasedPlan => simplify(phasedPlan)
    case planPhase: PlanPhase => new PhasedPlan(List(simplify(planPhase)).asJava, planPhase.getListeners)
    case plan: ExecutablePlan => new PhasedPlan(List(new PlanPhase(simplify(plan), plan.getDescription, plan.getListeners)).asJava, plan.getListeners)
  }

  def simplify(plan: ExecutablePlan): ExecutablePlan = plan match {
    case cp: CompositePlan if cp.getSubPlans.size() == 1 => simplify(cp.getSubPlans.get(0))
    case cp: CompositePlan => simplifyComposite(cp).getOrElse(cp.emptySteps())
    case p@_ => p
  }

  def simplify(phasedPlan: PhasedPlan): PhasedPlan = phasedPlan.copy(phases = phasedPlan.phases.asScala.map(simplify).asJava)

  def simplify(planPhase: PlanPhase): PlanPhase = planPhase.copy(plan = simplify(planPhase.plan))

  def simplifyComposite(plan: CompositePlan): Option[ExecutablePlan] = simplifySubplans(plan, plan.getClass) match {
    case Nil => None
    case head :: Nil => Some(head)
    case x@_ => Some(plan.copy(subPlans = x.asJava))
  }

  def simplifySubplans(plan: CompositePlan, cls: Class[_ <: CompositePlan]): List[ExecutablePlan] = plan.getSubPlans.asScala.collect({
    case p: Plan => simplify(p, cls)
  }).flatten.flatten.toList

  @SuppressWarnings(Array("ComparingUnrelatedTypes"))
  def simplify(plan: Plan, parentPlan: Class[_ <: CompositePlan]): Option[List[ExecutablePlan]] = plan match {
    case cp: CompositePlan if cp.getSubPlans.isEmpty => None
    case cp: CompositePlan if cp.getSubPlans.size() == 1 => simplify(cp.getSubPlans.get(0), parentPlan)
    case cp: CompositePlan if cp.getClass == parentPlan => simplifySubplans(cp, parentPlan) match {
      case Nil => None
      case x@_ => Some(x)
    }
    case cp: CompositePlan => simplifyComposite(cp).map(p => List(p))
    case p: StepPlan if !p.getSteps.isEmpty => Some(List(p))
    case _: StepPlan => None
  }

}
