package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact
import org.springframework.expression.spel.standard.SpelExpressionParser
import org.springframework.expression.spel.support.StandardEvaluationContext

import java.util.{Date, GregorianCalendar}

object SpelExpression extends App {

  simpleExpression()
  deployedsExpression()

  def evaluate(expression: String, root: AnyRef): AnyRef = {
    val parser = new SpelExpressionParser
    val exp = parser.parseExpression(expression)
    val context = new StandardEvaluationContext(root)
    exp.getValue(context)
  }

  def deployedsExpression(): Unit = {
    val deployed = new BaseDeployedArtifact
    val fileName = evaluate("deployed.file.name", deployed).asInstanceOf[String]
    println(s"fileName: $fileName")
  }

  def simpleExpression(): Unit = {
    val c = new GregorianCalendar
    c.set(1856, 7, 9)
    val tesla = Inventor("Nikola Tesla", c.getTime, "Serbian")
    val name = evaluate("name", tesla)
    println(s"name: $name")
  }
}

case class Inventor(name: String, birthday: Date, country: String)