package com.xebialabs.deployit.deployment.service

import org.springframework.beans.factory.FactoryBean
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ArtifactTransformerConfiguration {

  @Bean(Array("artifactTransformerFactory"))
  def serviceLocatorFactoryBean: FactoryBean[_] = {
    val factoryBean = new ServiceLocatorFactoryBean
    factoryBean.setServiceLocatorInterface(classOf[ArtifactTransformerFactory])
    factoryBean.setServiceLocatorExceptionClass(classOf[ArtifactTransformerNotDefinedException])
    factoryBean
  }

}
