package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.deployment.planner.PipedPlanner.{PlanTransformer, TransformerContext}
import com.xebialabs.deployit.deployment.planner.PlanSugar._
import com.xebialabs.deployit.deployment.planner._

import scala.jdk.CollectionConverters._

class FilterEmptyPhasePlanner extends PlanTransformer with PlanSugar {

  override def transform(context: TransformerContext): PhasedPlan =
    context.spec.getAllDeltaSpecifications.asScala.toList match {
      case head :: _ if head.getDeployedApplication.isOptimizePlan =>
        val phases = context.plan.phases.asScala.flatMap(phase => removeEmptyPlan(phase.plan).map(plan => phase.copy(plan = plan)))
        context.plan.copy(phases = phases.asJava)
      case _ => context.plan
    }

  private[this] def removeEmptyPlan(plan: ExecutablePlan): Option[ExecutablePlan] = plan match {
    case stepPlan: StepPlan => filterStepPlan(stepPlan)
    case compositePlan: CompositePlan => filterCompositePlan(compositePlan)
  }

  private[this] def filterCompositePlan(compositePlan: CompositePlan): Option[ExecutablePlan] =
    compositePlan.getSubPlans.asScala.flatMap(plan => removeEmptyPlan(plan)) match {
      case subPlans if subPlans.nonEmpty => Option(compositePlan.copy(subPlans = subPlans.asJava))
      case _ => None
    }

  private[this] def filterStepPlan(step: StepPlan): Option[StepPlan] =
    if (!step.getSteps.isEmpty) Some(step) else None

}
