package com.xebialabs.deployit.deployment

import com.xebialabs.deployit.deployment.planner.StepPlan
import com.xebialabs.deployit.deployment.planner.StepPlan.{Checkpoint, StepWithPlanningInfo}
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication
import com.xebialabs.platform.script.jython.ScriptSource

import java.util
import scala.jdk.CollectionConverters._

package object rules {

  final private[rules] val rulesXmlFileName = "xl-rules.xml"

  final private[rules] val rulesXsdLocation = "com/xebialabs/deployit/deployment/rules/xl-rules.xsd"

  final private[rules] val ruleLib = ScriptSource.byResource("com/xebialabs/deployit/deployment/rules/script_rule_lib.py")

  def getClassChain(c: Class[_]): Seq[Class[_]] = c +: Option(c.getSuperclass).map(getClassChain).getOrElse(Seq())

  def correctDeployedApplication(context: RulePlanningContext): DeployedApplication = if (context.getDeployedApplication == null) {
    context.getPreviousDeployedApplication
  } else {
    context.getDeployedApplication
  }

  object Implicits {

    implicit class StepPlannerMerger(val stepPlan: StepPlan) extends AnyVal {
      def merge(otherStepPlan: StepPlan): StepPlan = {
        new StepPlan(stepPlan.getDescription,
          mergeSteps(stepPlan.getStepsWithPlanningInfo, otherStepPlan.getStepsWithPlanningInfo),
          mergeCheckPoints(stepPlan.getCheckpoints, otherStepPlan.getCheckpoints),
          stepPlan.getListeners
        )
      }
      private def mergeCheckPoints(list1: util.List[Checkpoint], list2: util.List[Checkpoint]): util.List[Checkpoint] = {
        new util.ArrayList[Checkpoint]((list1.asScala.toList ++ list2.asScala.toList).asJava)
      }
      private def mergeSteps(list1: util.List[StepWithPlanningInfo], list2: util.List[StepWithPlanningInfo]): util.List[StepWithPlanningInfo] = {
        val t1 = list1.asScala.partition(_.getStep.getOrder < 50)
        val t2 = list2.asScala.partition(_.getStep.getOrder < 50)
        new util.ArrayList[StepWithPlanningInfo]((t2._1 ++ t1._1 ++ t1._2 ++ t2._2).asJava)
      }
    }
  }
}
