package com.xebialabs.deployit.repository.placeholders

import com.xebialabs.deployit.engine.api.dto
import com.xebialabs.deployit.engine.api.dto.Paging
import com.xebialabs.deployit.plugin.api.deployment.{Placeholder, PlaceholderCi, PlaceholderCiWithValue}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.security.RolesPermissionsPair

trait PlaceholderRepository {

  def savePlaceholders(cis: List[ConfigurationItem]): Unit

  def copyPlaceholders(fromPath: String, toPath: String): Unit

  def updatePlaceholders(cis: List[ConfigurationItem]): Unit

  def deletePlaceholders(ci: ConfigurationItem): Unit

  def deletePlaceholders(cis: List[ConfigurationItem]): Unit

  def updatePath(oldPath: String, newPath: String): Unit

  def getPlaceholders(key: String, applicationId: String,
                      applicationName: String, rolesPermissions: Option[RolesPermissionsPair], paging: Paging, order: dto.Ordering): List[Placeholder]

  def getPlaceholderKeys(key: String, rolesPermissions: Option[RolesPermissionsPair], paging: Paging, order: dto.Ordering): List[String]

  def getPlaceholdersWithDictionary(key: String, value: String, dictionaryId: String, dictionaryName: String,
                                    rolesPermissions: Option[RolesPermissionsPair], paging: Paging, order: dto.Ordering): List[PlaceholderCiWithValue]

  def getPlaceholdersWithEnvironment(key: String, environmentId: String, environmentName: String,
                                     rolesPermissions: Option[RolesPermissionsPair], paging: Paging, order: dto.Ordering): List[PlaceholderCi]

  def countAllPlaceholders(key: String, applicationId: String, applicationName: String, rolesPermissions: Option[RolesPermissionsPair]): Int

  def countPlaceholdersWithDictionary(key: String, value: String, dictionaryId: String, dictionaryName: String,
                                      rolesPermissions: Option[RolesPermissionsPair]): Int

  def countPlaceholdersWithEnvironment(key: String, environmentId: String, environmentName: String,
                                       rolesPermissions: Option[RolesPermissionsPair]): Int

}
