package ai.digital.engine.exportcis

import com.xebialabs.deployit.security.permission.PermissionHelper
import com.xebialabs.xlplatform.endpoints.AuthenticatedData
import org.apache.pekko.http.scaladsl.server.{AuthorizationFailedRejection, Directive0, Directives}

package object route extends Directives {
  def rejectNonAdmin(auth: AuthenticatedData): Directive0 = {
    if (PermissionHelper.isAdmin(auth.toAuthentication)) {
      pass
    } else {
      reject(AuthorizationFailedRejection)
    }
  }
}
