package ai.digital.engine.exportcis.route

import ai.digital.engine.exportcis.CisExportSupport
import ai.digital.engine.exportcis.archive.RepositoryExporter.RepositoryRootAlias
import com.xebialabs.deployit.repository.RepositoryServiceHolder.getRepositoryService
import com.xebialabs.xlplatform.config.{ConfigLoader, ConfigurationHolder}
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ExtensionRoutes}
import de.schlichtherle.truezip.util.UriDecoder
import grizzled.slf4j.Logging
import org.apache.pekko.actor.ActorSystem
import org.apache.pekko.http.scaladsl.model.StatusCodes.NotFound
import org.apache.pekko.http.scaladsl.server.Route

import java.nio.file.Paths

class ExportCisRoute extends ExtensionRoutes with Logging with CisExportSupport {

  private lazy val defaultExportDir = ConfigLoader.loadWithDynamic(ConfigurationHolder.get()).getString("deploy.server.export-cis.export-dir")

  private val uriDecoder = new UriDecoder()

  def route(system: ActorSystem): AuthenticatedData => Route = (auth: AuthenticatedData) => pathPrefix("export" / "citree") {
    post {
      path(Remaining) { ciIdEncoded =>
        rejectNonAdmin(auth) {
          val ciId = uriDecoder.decode(ciIdEncoded)
          parameter(Symbol("exportDir").?(defaultExportDir)) { exportDir =>
            logger.info(s"Trying to export CI tree starting from $ciId into $exportDir")
            ciId match {
              case "/" | "" => complete(export(RepositoryRootAlias, Paths.get(exportDir))(auth))
              case _ if getRepositoryService.exists(ciId) => complete(export(ciId, Paths.get(exportDir))(auth))
              case _ => complete(NotFound -> s"CI does not exist [$ciId]")
            }
          }
        }
      }
    }
  }
}
