package ai.digital.deploy.permissions.config.db

import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import ai.digital.deploy.permissions.configuration.JpaDialect
import grizzled.slf4j.Logging
import liquibase.Liquibase
import liquibase.database.jvm.JdbcConnection
import liquibase.resource.ClassLoaderResourceAccessor
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.context.annotation.{Configuration, Profile}

import jakarta.annotation.PostConstruct
import javax.sql.DataSource

@Configuration
@Profile(Array(EmbeddedPermissionServiceProfile))
class PermissionServiceLiquibaseConfiguration(@Qualifier("permissionDataSource") permissionDataSource: DataSource)
    extends Logging {
  @PostConstruct
  def initializePermissionSchemaDatabase(): Unit = {
    logger.debug(s"Running liquibase update - Permission Service")
    updateLiquibase("db/deploy-permission-service-changelog.yaml", permissionDataSource)
  }

  private def updateLiquibase(schema: String, dataSource: DataSource): Unit = {
    val connection = dataSource.getConnection
    try {
      val context = s"${JpaDialect.initializeDialect(dataSource).name}-${connection.getMetaData.getDatabaseMajorVersion}"
      logger.info(s"Detected liquibase context for Permission Service: $context")
      val liquibase = new Liquibase(
        schema,
        new ClassLoaderResourceAccessor(),
        new JdbcConnection(connection)
      )
      liquibase.update(context, schema)
    } finally connection.close()
  }
}
