package ai.digital.deploy.permissions

import ai.digital.deploy.permissions.config.profile.PermissionServiceProfileConfig.EmbeddedPermissionServiceProfile
import com.xebialabs.deployit.spring.profile.DynamicActiveProfile
import com.xebialabs.deployit.{ServerConfiguration, ServerLaunchOptions}

class PermissionServiceActiveProfile extends DynamicActiveProfile {
  override val profileNames: Array[String] =
    Array(EmbeddedPermissionServiceProfile)

  override def launchOptionsCallback(launchOptions: ServerLaunchOptions): Boolean = false

  override def configPropertyCallback(serverConfiguration: ServerConfiguration): Boolean =
    Option(serverConfiguration).exists(_.isExternalPermissionService)
}
