/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonParser;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.ExecutableHandler;
import com.google.auth.oauth2.ExecutableResponse;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.PluggableAuthException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class PluggableAuthHandler
implements ExecutableHandler {
    private static final int EXECUTABLE_SUPPORTED_MAX_VERSION = 1;
    private static final String GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES = "GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES";
    private static final int EXIT_CODE_SUCCESS = 0;
    private final EnvironmentProvider environmentProvider;
    private InternalProcessBuilder internalProcessBuilder;

    PluggableAuthHandler(EnvironmentProvider environmentProvider) {
        this.environmentProvider = environmentProvider;
    }

    @VisibleForTesting
    PluggableAuthHandler(EnvironmentProvider environmentProvider, InternalProcessBuilder internalProcessBuilder) {
        this.environmentProvider = environmentProvider;
        this.internalProcessBuilder = internalProcessBuilder;
    }

    @Override
    public String retrieveTokenFromExecutable(ExecutableHandler.ExecutableOptions options) throws IOException {
        if (!"1".equals(this.environmentProvider.getEnv(GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES))) {
            throw new PluggableAuthException("PLUGGABLE_AUTH_DISABLED", "Pluggable Auth executables need to be explicitly allowed to run by setting the GOOGLE_EXTERNAL_ACCOUNT_ALLOW_EXECUTABLES environment variable to 1.");
        }
        ExecutableResponse executableResponse = this.getCachedExecutableResponse(options);
        if (executableResponse == null) {
            executableResponse = this.getExecutableResponse(options);
        }
        if (options.getOutputFilePath() != null && !options.getOutputFilePath().isEmpty() && executableResponse.isSuccessful() && executableResponse.getExpirationTime() == null) {
            throw new PluggableAuthException("INVALID_EXECUTABLE_RESPONSE", "The executable response must contain the `expiration_time` field for successful responses when an output_file has been specified in the configuration.");
        }
        if (executableResponse.getVersion() > 1) {
            throw new PluggableAuthException("UNSUPPORTED_VERSION", "The version of the executable response is not supported. " + String.format("The maximum version currently supported is %s.", 1));
        }
        if (!executableResponse.isSuccessful()) {
            throw new PluggableAuthException(executableResponse.getErrorCode(), executableResponse.getErrorMessage());
        }
        if (executableResponse.isExpired()) {
            throw new PluggableAuthException("INVALID_RESPONSE", "The executable response is expired.");
        }
        return executableResponse.getSubjectToken();
    }

    @Nullable
    ExecutableResponse getCachedExecutableResponse(ExecutableHandler.ExecutableOptions options) throws PluggableAuthException {
        ExecutableResponse executableResponse = null;
        if (options.getOutputFilePath() != null && !options.getOutputFilePath().isEmpty()) {
            try {
                FileInputStream inputStream;
                BufferedReader reader;
                JsonParser parser;
                ExecutableResponse cachedResponse;
                File outputFile = new File(options.getOutputFilePath());
                if (outputFile.isFile() && outputFile.length() > 0L && (cachedResponse = new ExecutableResponse((GenericJson)(parser = OAuth2Utils.JSON_FACTORY.createJsonParser((Reader)(reader = new BufferedReader(new InputStreamReader((InputStream)(inputStream = new FileInputStream(options.getOutputFilePath())), StandardCharsets.UTF_8))))).parseAndClose(GenericJson.class))).isValid()) {
                    executableResponse = cachedResponse;
                }
            }
            catch (Exception e) {
                throw new PluggableAuthException("INVALID_OUTPUT_FILE", "The output_file specified contains an invalid or malformed response." + e);
            }
        }
        return executableResponse;
    }

    ExecutableResponse getExecutableResponse(ExecutableHandler.ExecutableOptions options) throws IOException {
        ExecutableResponse execResp;
        List components = Splitter.on((String)" ").splitToList((CharSequence)options.getExecutableCommand());
        InternalProcessBuilder processBuilder = this.getProcessBuilder(components);
        Map<String, String> envMap = processBuilder.environment();
        envMap.putAll(options.getEnvironmentMap());
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        String executableOutput = "";
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<String> future = executor.submit(() -> {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append(System.lineSeparator());
                }
                return sb.toString().trim();
            });
            boolean success = process.waitFor(options.getExecutableTimeoutMs(), TimeUnit.MILLISECONDS);
            if (!success) {
                throw new PluggableAuthException("TIMEOUT_EXCEEDED", "The executable failed to finish within the timeout specified.");
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new PluggableAuthException("EXIT_CODE", String.format("The executable failed with exit code %s.", exitCode));
            }
            executableOutput = future.get();
            executor.shutdownNow();
            JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(executableOutput);
            execResp = new ExecutableResponse((GenericJson)parser.parseAndClose(GenericJson.class));
        }
        catch (IOException e) {
            process.destroy();
            if (!executor.isShutdown()) {
                executor.shutdownNow();
            }
            if (e instanceof PluggableAuthException) {
                throw e;
            }
            throw new PluggableAuthException("INVALID_RESPONSE", String.format("The executable returned an invalid response: %s.", executableOutput));
        }
        catch (InterruptedException | ExecutionException e) {
            process.destroy();
            throw new PluggableAuthException("INTERRUPTED", String.format("The execution was interrupted: %s.", e));
        }
        process.destroy();
        return execResp;
    }

    InternalProcessBuilder getProcessBuilder(List<String> commandComponents) {
        if (this.internalProcessBuilder != null) {
            return this.internalProcessBuilder;
        }
        return new DefaultProcessBuilder(new ProcessBuilder(commandComponents));
    }

    static final class DefaultProcessBuilder
    extends InternalProcessBuilder {
        ProcessBuilder processBuilder;

        DefaultProcessBuilder(ProcessBuilder processBuilder) {
            this.processBuilder = processBuilder;
        }

        @Override
        Map<String, String> environment() {
            return this.processBuilder.environment();
        }

        @Override
        InternalProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
            this.processBuilder.redirectErrorStream(redirectErrorStream);
            return this;
        }

        @Override
        Process start() throws IOException {
            return this.processBuilder.start();
        }
    }

    static abstract class InternalProcessBuilder {
        InternalProcessBuilder() {
        }

        abstract Map<String, String> environment();

        abstract InternalProcessBuilder redirectErrorStream(boolean var1);

        abstract Process start() throws IOException;
    }
}

