/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.iteration;

import com.ibm.asyncutil.iteration.AsyncIterator;
import com.ibm.asyncutil.iteration.AsyncQueue;
import com.ibm.asyncutil.iteration.BoundedAsyncQueue;
import com.ibm.asyncutil.locks.AsyncSemaphore;
import com.ibm.asyncutil.locks.FairAsyncSemaphore;
import com.ibm.asyncutil.util.Either;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class AsyncQueues {
    private AsyncQueues() {
    }

    public static <T> AsyncQueue<T> unbounded() {
        return new UnboundedQueue();
    }

    public static <T> BoundedAsyncQueue<T> bounded() {
        return new BufferedQueue(1);
    }

    public static <T> BoundedAsyncQueue<T> buffered(int maxBuffer) {
        return new BufferedQueue(maxBuffer);
    }

    private static class BufferedQueue<T>
    implements BoundedAsyncQueue<T> {
        final AsyncSemaphore sendThrottle;
        final AsyncQueue<T> backingQueue;

        BufferedQueue(int bufferSize) {
            this.sendThrottle = new FairAsyncSemaphore(bufferSize);
            this.backingQueue = AsyncQueues.unbounded();
        }

        @Override
        public CompletionStage<Either<AsyncIterator.End, T>> nextStage() {
            return this.backingQueue.nextStage().thenApply(res -> {
                res.forEach(ig -> {}, t -> this.sendThrottle.release());
                return res;
            });
        }

        @Override
        public CompletionStage<Boolean> send(T item) {
            return this.sendThrottle.acquire().thenApply(ig -> {
                boolean accepted = this.backingQueue.send(item);
                if (!accepted) {
                    this.sendThrottle.release();
                }
                return accepted;
            });
        }

        @Override
        public CompletionStage<Void> terminate() {
            return this.sendThrottle.acquire().thenApply(res -> {
                this.backingQueue.terminate();
                this.sendThrottle.release();
                return res;
            });
        }

        @Override
        public Optional<T> poll() {
            Optional<Object> poll = this.backingQueue.poll();
            poll.ifPresent(ig -> this.sendThrottle.release());
            return poll;
        }
    }

    private static final class UnboundedQueue<T>
    implements AsyncQueue<T> {
        private static final AtomicReferenceFieldUpdater<UnboundedQueue, Node> TAIL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UnboundedQueue.class, Node.class, "tail");
        private static final Node<?> STOP = new Node(AsyncIterator.End.end());
        private Node<T> head;
        private volatile Node<T> tail;

        private UnboundedQueue() {
            Node headTail = new Node();
            this.head = headTail;
            this.tail = headTail;
        }

        @Override
        public CompletableFuture<Either<AsyncIterator.End, T>> nextStage() {
            return this.head.thenApply((T res) -> {
                this.head = ((Node)this.head).next;
                return res;
            });
        }

        @Override
        public Optional<T> poll() {
            Either currentResult = this.head.getNow(null);
            if (currentResult != null) {
                this.head = ((Node)this.head).next;
                return currentResult.right();
            }
            return Optional.empty();
        }

        @Override
        public boolean send(T item) {
            return this.sendImpl(Either.right(item), new Node());
        }

        @Override
        public void terminate() {
            this.sendImpl(AsyncIterator.End.end(), UnboundedQueue.stopNode());
        }

        private boolean sendImpl(Either<AsyncIterator.End, T> item, Node<T> newTail) {
            Node<Either<AsyncIterator.End, T>> oldTail;
            do {
                if ((oldTail = this.tail) != STOP) continue;
                return false;
            } while (!TAIL_UPDATER.compareAndSet(this, oldTail, newTail));
            ((Node)oldTail).next = (Node)newTail;
            oldTail.complete(item);
            return true;
        }

        private static <T> Node<T> stopNode() {
            return STOP;
        }

        static {
            ((Node)STOP).next = UnboundedQueue.stopNode();
        }

        private static class Node<T>
        extends CompletableFuture<Either<AsyncIterator.End, T>> {
            private Node<T> next = null;

            Node() {
            }

            Node(Either<AsyncIterator.End, T> c) {
                super.complete(c);
            }
        }
    }
}

