/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import jakarta.inject.Provider;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionOverrideException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.NullBean;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.ScopeNotActiveException;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.OrderComparator;
import org.springframework.core.ResolvableType;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.log.LogMessage;
import org.springframework.core.metrics.StartupStep;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.CompositeIterator;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry,
Serializable {
    public static final String STRICT_LOCKING_PROPERTY_NAME = "spring.locking.strict";
    @Nullable
    private static Class<?> jakartaInjectProviderClass;
    private static final Map<String, Reference<DefaultListableBeanFactory>> serializableFactories;
    @Nullable
    private final Boolean strictLocking = SpringProperties.checkFlag((String)"spring.locking.strict");
    @Nullable
    private String serializationId;
    @Nullable
    private Boolean allowBeanDefinitionOverriding;
    private boolean allowEagerClassLoading = true;
    @Nullable
    private Executor bootstrapExecutor;
    @Nullable
    private Comparator<Object> dependencyComparator;
    private AutowireCandidateResolver autowireCandidateResolver = SimpleAutowireCandidateResolver.INSTANCE;
    private final Map<Class<?>, Object> resolvableDependencies = new ConcurrentHashMap(16);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(256);
    private final Map<String, BeanDefinitionHolder> mergedBeanDefinitionHolders = new ConcurrentHashMap<String, BeanDefinitionHolder>(256);
    private final Map<String, Class<?>> primaryBeanNamesWithType = new ConcurrentHashMap(16);
    private final Map<Class<?>, String[]> allBeanNamesByType = new ConcurrentHashMap(64);
    private final Map<Class<?>, String[]> singletonBeanNamesByType = new ConcurrentHashMap(64);
    private volatile List<String> beanDefinitionNames = new ArrayList<String>(256);
    private volatile Set<String> manualSingletonNames = new LinkedHashSet<String>(16);
    @Nullable
    private volatile String[] frozenBeanDefinitionNames;
    private volatile boolean configurationFrozen;
    @Nullable
    private volatile String mainThreadPrefix;
    private final NamedThreadLocal<PreInstantiation> preInstantiationThread = new NamedThreadLocal("Pre-instantiation thread marker");

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(@Nullable BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setSerializationId(@Nullable String serializationId) {
        if (serializationId != null) {
            serializableFactories.put(serializationId, new WeakReference<DefaultListableBeanFactory>(this));
        } else if (this.serializationId != null) {
            serializableFactories.remove(this.serializationId);
        }
        this.serializationId = serializationId;
    }

    @Nullable
    public String getSerializationId() {
        return this.serializationId;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public boolean isAllowBeanDefinitionOverriding() {
        return !Boolean.FALSE.equals(this.allowBeanDefinitionOverriding);
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public boolean isAllowEagerClassLoading() {
        return this.allowEagerClassLoading;
    }

    @Override
    public void setBootstrapExecutor(@Nullable Executor bootstrapExecutor) {
        this.bootstrapExecutor = bootstrapExecutor;
    }

    @Override
    @Nullable
    public Executor getBootstrapExecutor() {
        return this.bootstrapExecutor;
    }

    public void setDependencyComparator(@Nullable Comparator<Object> dependencyComparator) {
        this.dependencyComparator = dependencyComparator;
    }

    @Nullable
    public Comparator<Object> getDependencyComparator() {
        return this.dependencyComparator;
    }

    public void setAutowireCandidateResolver(AutowireCandidateResolver autowireCandidateResolver) {
        Assert.notNull((Object)autowireCandidateResolver, (String)"AutowireCandidateResolver must not be null");
        if (autowireCandidateResolver instanceof BeanFactoryAware) {
            BeanFactoryAware beanFactoryAware = (BeanFactoryAware)((Object)autowireCandidateResolver);
            beanFactoryAware.setBeanFactory(this);
        }
        this.autowireCandidateResolver = autowireCandidateResolver;
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.autowireCandidateResolver;
    }

    @Override
    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
            this.bootstrapExecutor = otherListableFactory.bootstrapExecutor;
            this.dependencyComparator = otherListableFactory.dependencyComparator;
            this.setAutowireCandidateResolver(otherListableFactory.getAutowireCandidateResolver().cloneIfNecessary());
            this.resolvableDependencies.putAll(otherListableFactory.resolvableDependencies);
        }
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBean(requiredType, (Object[])null);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        Assert.notNull(requiredType, (String)"Required type must not be null");
        T resolved = this.resolveBean(ResolvableType.forRawClass(requiredType), args, false);
        if (resolved == null) {
            throw new NoSuchBeanDefinitionException(requiredType);
        }
        return resolved;
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        Assert.notNull(requiredType, (String)"Required type must not be null");
        return this.getBeanProvider(ResolvableType.forRawClass(requiredType), true);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return this.getBeanProvider(requiredType, true);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        return this.beanDefinitionMap.containsKey(beanName);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        String[] frozenNames = this.frozenBeanDefinitionNames;
        if (frozenNames != null) {
            return (String[])frozenNames.clone();
        }
        return StringUtils.toStringArray(this.beanDefinitionNames);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
        Assert.notNull(requiredType, (String)"Required type must not be null");
        return this.getBeanProvider(ResolvableType.forRawClass(requiredType), allowEagerInit);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(final ResolvableType requiredType, final boolean allowEagerInit) {
        return new BeanObjectProvider<T>(){

            @Override
            public T getObject() throws BeansException {
                Object resolved = DefaultListableBeanFactory.this.resolveBean(requiredType, null, false);
                if (resolved == null) {
                    throw new NoSuchBeanDefinitionException(requiredType);
                }
                return resolved;
            }

            @Override
            public T getObject(Object ... args) throws BeansException {
                Object resolved = DefaultListableBeanFactory.this.resolveBean(requiredType, args, false);
                if (resolved == null) {
                    throw new NoSuchBeanDefinitionException(requiredType);
                }
                return resolved;
            }

            @Override
            @Nullable
            public T getIfAvailable() throws BeansException {
                try {
                    return DefaultListableBeanFactory.this.resolveBean(requiredType, null, false);
                }
                catch (ScopeNotActiveException ex) {
                    return null;
                }
            }

            @Override
            public void ifAvailable(Consumer<T> dependencyConsumer) throws BeansException {
                Object dependency = this.getIfAvailable();
                if (dependency != null) {
                    try {
                        dependencyConsumer.accept(dependency);
                    }
                    catch (ScopeNotActiveException scopeNotActiveException) {
                        // empty catch block
                    }
                }
            }

            @Override
            @Nullable
            public T getIfUnique() throws BeansException {
                try {
                    return DefaultListableBeanFactory.this.resolveBean(requiredType, null, true);
                }
                catch (ScopeNotActiveException ex) {
                    return null;
                }
            }

            @Override
            public void ifUnique(Consumer<T> dependencyConsumer) throws BeansException {
                Object dependency = this.getIfUnique();
                if (dependency != null) {
                    try {
                        dependencyConsumer.accept(dependency);
                    }
                    catch (ScopeNotActiveException scopeNotActiveException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public Stream<T> stream() {
                return Arrays.stream(DefaultListableBeanFactory.this.beanNamesForStream(requiredType, true, allowEagerInit)).map(name -> DefaultListableBeanFactory.this.getBean((String)name)).filter(bean -> !(bean instanceof NullBean));
            }

            @Override
            public Stream<T> orderedStream() {
                String[] beanNames = DefaultListableBeanFactory.this.beanNamesForStream(requiredType, true, allowEagerInit);
                if (beanNames.length == 0) {
                    return Stream.empty();
                }
                LinkedHashMap matchingBeans = CollectionUtils.newLinkedHashMap((int)beanNames.length);
                for (String beanName : beanNames) {
                    Object beanInstance = DefaultListableBeanFactory.this.getBean(beanName);
                    if (beanInstance instanceof NullBean) continue;
                    matchingBeans.put(beanName, beanInstance);
                }
                Stream stream = matchingBeans.values().stream();
                return stream.sorted(DefaultListableBeanFactory.this.adaptOrderComparator(matchingBeans));
            }

            @Override
            public Stream<T> stream(Predicate<Class<?>> customFilter, boolean includeNonSingletons) {
                return Arrays.stream(DefaultListableBeanFactory.this.beanNamesForStream(requiredType, includeNonSingletons, allowEagerInit)).filter(name -> customFilter.test(DefaultListableBeanFactory.this.getType((String)name))).map(name -> DefaultListableBeanFactory.this.getBean((String)name)).filter(bean -> !(bean instanceof NullBean));
            }

            @Override
            public Stream<T> orderedStream(Predicate<Class<?>> customFilter, boolean includeNonSingletons) {
                String[] beanNames = DefaultListableBeanFactory.this.beanNamesForStream(requiredType, includeNonSingletons, allowEagerInit);
                if (beanNames.length == 0) {
                    return Stream.empty();
                }
                LinkedHashMap matchingBeans = CollectionUtils.newLinkedHashMap((int)beanNames.length);
                for (String beanName : beanNames) {
                    Object beanInstance;
                    if (!customFilter.test(DefaultListableBeanFactory.this.getType(beanName)) || (beanInstance = DefaultListableBeanFactory.this.getBean(beanName)) instanceof NullBean) continue;
                    matchingBeans.put(beanName, beanInstance);
                }
                return matchingBeans.values().stream().sorted(DefaultListableBeanFactory.this.adaptOrderComparator(matchingBeans));
            }
        };
    }

    @Nullable
    private <T> T resolveBean(ResolvableType requiredType, @Nullable Object[] args, boolean nonUniqueAsNull) {
        NamedBeanHolder<T> namedBean = this.resolveNamedBean(requiredType, args, nonUniqueAsNull);
        if (namedBean != null) {
            return namedBean.getBeanInstance();
        }
        BeanFactory parent = this.getParentBeanFactory();
        if (parent instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)parent;
            return dlbf.resolveBean(requiredType, args, nonUniqueAsNull);
        }
        if (parent != null) {
            ObjectProvider parentProvider = parent.getBeanProvider(requiredType);
            if (args != null) {
                return parentProvider.getObject(args);
            }
            return nonUniqueAsNull ? parentProvider.getIfUnique() : parentProvider.getIfAvailable();
        }
        return null;
    }

    private String[] beanNamesForStream(ResolvableType requiredType, boolean includeNonSingletons, boolean allowEagerInit) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this, requiredType, includeNonSingletons, allowEagerInit);
    }

    @Override
    public String[] getBeanNamesForType(ResolvableType type) {
        return this.getBeanNamesForType(type, true, true);
    }

    @Override
    public String[] getBeanNamesForType(ResolvableType type, boolean includeNonSingletons, boolean allowEagerInit) {
        Class resolved = type.resolve();
        if (resolved != null && !type.hasGenerics()) {
            return this.getBeanNamesForType(resolved, includeNonSingletons, allowEagerInit);
        }
        return this.doGetBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    @Override
    public String[] getBeanNamesForType(@Nullable Class<?> type) {
        return this.getBeanNamesForType(type, true, true);
    }

    @Override
    public String[] getBeanNamesForType(@Nullable Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        if (!this.isConfigurationFrozen() || type == null || !allowEagerInit) {
            return this.doGetBeanNamesForType(ResolvableType.forRawClass(type), includeNonSingletons, allowEagerInit);
        }
        Map<Class<?>, String[]> cache = includeNonSingletons ? this.allBeanNamesByType : this.singletonBeanNamesByType;
        String[] resolvedBeanNames = cache.get(type);
        if (resolvedBeanNames != null) {
            return resolvedBeanNames;
        }
        resolvedBeanNames = this.doGetBeanNamesForType(ResolvableType.forRawClass(type), includeNonSingletons, true);
        if (ClassUtils.isCacheSafe(type, (ClassLoader)this.getBeanClassLoader())) {
            cache.put(type, resolvedBeanNames);
        }
        return resolvedBeanNames;
    }

    /*
     * WARNING - void declaration
     */
    private String[] doGetBeanNamesForType(ResolvableType type, boolean includeNonSingletons, boolean allowEagerInit) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String string : this.beanDefinitionNames) {
            if (this.isAlias(string)) continue;
            try {
                void var6_6;
                boolean isNonLazyDecorated;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(string);
                if (mbd.isAbstract() || !allowEagerInit && (!mbd.hasBeanClass() && mbd.isLazyInit() && !this.isAllowEagerClassLoading() || this.requiresEagerInitForType(mbd.getFactoryBeanName()))) continue;
                boolean isFactoryBean = this.isFactoryBean(string, mbd);
                BeanDefinitionHolder dbd = mbd.getDecoratedDefinition();
                boolean matchFound = false;
                boolean allowFactoryBeanInit = allowEagerInit || this.containsSingleton(string);
                boolean bl = isNonLazyDecorated = dbd != null && !mbd.isLazyInit();
                if (!isFactoryBean) {
                    if (includeNonSingletons || this.isSingleton(string, mbd, dbd)) {
                        matchFound = this.isTypeMatch(string, type, allowFactoryBeanInit);
                    }
                } else {
                    if (includeNonSingletons || isNonLazyDecorated) {
                        matchFound = this.isTypeMatch(string, type, allowFactoryBeanInit);
                    } else if (allowFactoryBeanInit) {
                        boolean bl2 = matchFound = this.isTypeMatch(string, type, allowFactoryBeanInit) && this.isSingleton(string, mbd, dbd);
                    }
                    if (!matchFound) {
                        String string2 = "&" + string;
                        if (includeNonSingletons || this.isSingleton(string2, mbd, dbd)) {
                            matchFound = this.isTypeMatch(string2, type, allowFactoryBeanInit);
                        }
                    }
                }
                if (!matchFound) continue;
                result.add(var6_6);
            }
            catch (BeanDefinitionStoreException | CannotLoadBeanClassException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                LogMessage message = ex instanceof CannotLoadBeanClassException ? LogMessage.format((String)"Ignoring bean class loading failure for bean '%s'", (Object)string) : LogMessage.format((String)"Ignoring unresolvable metadata in bean definition '%s'", (Object)string);
                this.logger.trace((Object)message, (Throwable)((Object)ex));
                this.onSuppressedException((Exception)((Object)ex));
            }
            catch (NoSuchBeanDefinitionException ex) {}
        }
        for (String string : this.manualSingletonNames) {
            try {
                void var6_12;
                if (this.isFactoryBean(string)) {
                    if ((includeNonSingletons || this.isSingleton(string)) && this.isTypeMatch(string, type)) {
                        result.add(string);
                        continue;
                    }
                    String string3 = "&" + string;
                }
                if (!this.isTypeMatch((String)var6_12, type)) continue;
                result.add(var6_12);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.logger.trace((Object)LogMessage.format((String)"Failed to check manually registered singleton with name '%s'", (Object)string), (Throwable)((Object)ex));
            }
        }
        return StringUtils.toStringArray(result);
    }

    private boolean isSingleton(String beanName, RootBeanDefinition mbd, @Nullable BeanDefinitionHolder dbd) {
        return dbd != null ? mbd.isSingleton() : this.isSingleton(beanName);
    }

    private boolean requiresEagerInitForType(@Nullable String factoryBeanName) {
        return factoryBeanName != null && this.isFactoryBean(factoryBeanName) && !this.containsSingleton(factoryBeanName);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(@Nullable Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(@Nullable Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)beanNames.length);
        for (String beanName : beanNames) {
            try {
                Object beanInstance = this.getBean(beanName);
                if (beanInstance instanceof NullBean) continue;
                result.put(beanName, beanInstance);
            }
            catch (BeanCreationException ex) {
                BeanCurrentlyInCreationException bce;
                String exBeanName;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && (exBeanName = (bce = (BeanCurrentlyInCreationException)((Object)rootCause)).getBeanName()) != null && this.isCurrentlyInCreation(exBeanName)) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Ignoring match to currently created bean '" + exBeanName + "': " + ex.getMessage()));
                    }
                    this.onSuppressedException((Exception)((Object)ex));
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    @Override
    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList<String> result = new ArrayList<String>();
        for (String beanName : this.beanDefinitionNames) {
            BeanDefinition bd = this.beanDefinitionMap.get(beanName);
            if (bd == null || bd.isAbstract() || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            result.add(beanName);
        }
        for (String beanName : this.manualSingletonNames) {
            if (result.contains(beanName) || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            result.add(beanName);
        }
        return StringUtils.toStringArray(result);
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        String[] beanNames = this.getBeanNamesForAnnotation(annotationType);
        LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)beanNames.length);
        for (String beanName : beanNames) {
            Object beanInstance = this.getBean(beanName);
            if (beanInstance instanceof NullBean) continue;
            result.put(beanName, beanInstance);
        }
        return result;
    }

    @Override
    @Nullable
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        return this.findAnnotationOnBean(beanName, annotationType, true);
    }

    @Override
    @Nullable
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        MergedAnnotation annotation;
        Class<?> beanType = this.getType(beanName, allowFactoryBeanInit);
        if (beanType != null && (annotation = MergedAnnotations.from(beanType, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType)).isPresent()) {
            return (A)annotation.synthesize();
        }
        if (this.containsBeanDefinition(beanName)) {
            MergedAnnotation annotation2;
            Class<?> beanClass;
            RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
            if (bd.hasBeanClass() && bd.getFactoryMethodName() == null && (beanClass = bd.getBeanClass()) != beanType && (annotation2 = MergedAnnotations.from(beanClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType)).isPresent()) {
                return (A)annotation2.synthesize();
            }
            Method factoryMethod = bd.getResolvedFactoryMethod();
            if (factoryMethod != null && (annotation2 = MergedAnnotations.from((AnnotatedElement)factoryMethod, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType)).isPresent()) {
                return (A)annotation2.synthesize();
            }
        }
        return null;
    }

    @Override
    public <A extends Annotation> Set<A> findAllAnnotationsOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        LinkedHashSet annotations = new LinkedHashSet();
        Class<?> beanType = this.getType(beanName, allowFactoryBeanInit);
        if (beanType != null) {
            MergedAnnotations.from(beanType, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(annotationType).filter(MergedAnnotation::isPresent).forEach(mergedAnnotation -> annotations.add(mergedAnnotation.synthesize()));
        }
        if (this.containsBeanDefinition(beanName)) {
            Method factoryMethod;
            Class<?> beanClass;
            RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
            if (bd.hasBeanClass() && bd.getFactoryMethodName() == null && (beanClass = bd.getBeanClass()) != beanType) {
                MergedAnnotations.from(beanClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(annotationType).filter(MergedAnnotation::isPresent).forEach(mergedAnnotation -> annotations.add(mergedAnnotation.synthesize()));
            }
            if ((factoryMethod = bd.getResolvedFactoryMethod()) != null) {
                MergedAnnotations.from((AnnotatedElement)factoryMethod, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(annotationType).filter(MergedAnnotation::isPresent).forEach(mergedAnnotation -> annotations.add(mergedAnnotation.synthesize()));
            }
        }
        return annotations;
    }

    @Override
    public void registerResolvableDependency(Class<?> dependencyType, @Nullable Object autowiredValue) {
        Assert.notNull(dependencyType, (String)"Dependency type must not be null");
        if (autowiredValue != null) {
            if (!(autowiredValue instanceof ObjectFactory) && !dependencyType.isInstance(autowiredValue)) {
                throw new IllegalArgumentException("Value [" + String.valueOf(autowiredValue) + "] does not implement specified dependency type [" + dependencyType.getName() + "]");
            }
            this.resolvableDependencies.put(dependencyType, autowiredValue);
        }
    }

    @Override
    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        return this.isAutowireCandidate(beanName, descriptor, this.getAutowireCandidateResolver());
    }

    protected boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor, AutowireCandidateResolver resolver) throws NoSuchBeanDefinitionException {
        String bdName = this.transformedBeanName(beanName);
        if (this.containsBeanDefinition(bdName)) {
            return this.isAutowireCandidate(beanName, this.getMergedLocalBeanDefinition(bdName), descriptor, resolver);
        }
        if (this.containsSingleton(beanName)) {
            return this.isAutowireCandidate(beanName, new RootBeanDefinition(this.getType(beanName)), descriptor, resolver);
        }
        BeanFactory parent = this.getParentBeanFactory();
        if (parent instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)parent;
            return dlbf.isAutowireCandidate(beanName, descriptor, resolver);
        }
        if (parent instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)parent;
            return clbf.isAutowireCandidate(beanName, descriptor);
        }
        return true;
    }

    protected boolean isAutowireCandidate(String beanName, RootBeanDefinition mbd, DependencyDescriptor descriptor, AutowireCandidateResolver resolver) {
        String bdName = this.transformedBeanName(beanName);
        this.resolveBeanClass(mbd, bdName, new Class[0]);
        if (mbd.isFactoryMethodUnique && mbd.factoryMethodToIntrospect == null) {
            new ConstructorResolver(this).resolveFactoryMethodIfPossible(mbd);
        }
        BeanDefinitionHolder holder = beanName.equals(bdName) ? this.mergedBeanDefinitionHolders.computeIfAbsent(beanName, key -> new BeanDefinitionHolder(mbd, beanName, this.getAliases(bdName))) : new BeanDefinitionHolder(mbd, beanName, this.getAliases(bdName));
        return resolver.isAutowireCandidate(holder, descriptor);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + String.valueOf(this)));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    @Override
    public Iterator<String> getBeanNamesIterator() {
        CompositeIterator iterator = new CompositeIterator();
        iterator.add(this.beanDefinitionNames.iterator());
        iterator.add(this.manualSingletonNames.iterator());
        return iterator;
    }

    @Override
    protected void clearMergedBeanDefinition(String beanName) {
        super.clearMergedBeanDefinition(beanName);
        this.mergedBeanDefinitionHolders.remove(beanName);
    }

    @Override
    public void clearMetadataCache() {
        super.clearMetadataCache();
        this.mergedBeanDefinitionHolders.clear();
        this.clearByTypeCache();
    }

    @Override
    public void freezeConfiguration() {
        this.clearMetadataCache();
        this.configurationFrozen = true;
        this.frozenBeanDefinitionNames = StringUtils.toStringArray(this.beanDefinitionNames);
    }

    @Override
    public boolean isConfigurationFrozen() {
        return this.configurationFrozen;
    }

    @Override
    protected boolean isBeanEligibleForMetadataCaching(String beanName) {
        return this.configurationFrozen || super.isBeanEligibleForMetadataCaching(beanName);
    }

    @Override
    @Nullable
    protected Object obtainInstanceFromSupplier(Supplier<?> supplier, String beanName, RootBeanDefinition mbd) throws Exception {
        if (supplier instanceof InstanceSupplier) {
            InstanceSupplier instanceSupplier = (InstanceSupplier)((Object)supplier);
            return instanceSupplier.get(RegisteredBean.of(this, beanName, mbd));
        }
        return super.obtainInstanceFromSupplier(supplier, beanName, mbd);
    }

    @Override
    protected void cacheMergedBeanDefinition(RootBeanDefinition mbd, String beanName) {
        super.cacheMergedBeanDefinition(mbd, beanName);
        if (mbd.isPrimary()) {
            this.primaryBeanNamesWithType.put(beanName, Void.class);
        }
    }

    @Override
    protected void checkMergedBeanDefinition(RootBeanDefinition mbd, String beanName, @Nullable Object[] args) {
        super.checkMergedBeanDefinition(mbd, beanName, args);
        if (mbd.isBackgroundInit()) {
            if (this.preInstantiationThread.get() == PreInstantiation.MAIN && this.getBootstrapExecutor() != null) {
                throw new BeanCurrentlyInCreationException(beanName, "Bean marked for background initialization but requested in mainline thread - declare ObjectProvider or lazy injection point in dependent mainline beans");
            }
        } else if (this.preInstantiationThread.get() == PreInstantiation.BACKGROUND) {
            throw new BeanCurrentlyInCreationException(beanName, "Bean marked for mainline initialization but requested in background thread - enforce early instantiation in mainline thread through depends-on '" + beanName + "' declaration for dependent background beans");
        }
    }

    @Override
    @Nullable
    protected Boolean isCurrentThreadAllowedToHoldSingletonLock() {
        String mainThreadPrefix = this.mainThreadPrefix;
        if (mainThreadPrefix != null) {
            PreInstantiation preInstantiation = (PreInstantiation)((Object)this.preInstantiationThread.get());
            if (preInstantiation != null) {
                return switch (preInstantiation) {
                    default -> throw new IncompatibleClassChangeError();
                    case PreInstantiation.MAIN -> {
                        if (Boolean.TRUE.equals(this.strictLocking)) {
                            yield null;
                        }
                        yield true;
                    }
                    case PreInstantiation.BACKGROUND -> false;
                };
            }
            if (Boolean.FALSE.equals(this.strictLocking)) {
                return true;
            }
            if (this.strictLocking == null && !DefaultListableBeanFactory.getThreadNamePrefix().equals(mainThreadPrefix)) {
                return true;
            }
        }
        return null;
    }

    @Override
    public void prepareSingletonBootstrap() {
        this.mainThreadPrefix = DefaultListableBeanFactory.getThreadNamePrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Pre-instantiating singletons in " + String.valueOf(this)));
        }
        ArrayList<String> beanNames = new ArrayList<String>(this.beanDefinitionNames);
        this.preInstantiationThread.set((Object)PreInstantiation.MAIN);
        if (this.mainThreadPrefix == null) {
            this.mainThreadPrefix = DefaultListableBeanFactory.getThreadNamePrefix();
        }
        try {
            ArrayList futures = new ArrayList();
            for (String beanName : beanNames) {
                CompletableFuture<?> future;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                if (mbd.isAbstract() || !mbd.isSingleton() || (future = this.preInstantiateSingleton(beanName, mbd)) == null) continue;
                futures.add(future);
            }
            if (!futures.isEmpty()) {
                try {
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
                }
                catch (CompletionException ex) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)ex.getCause());
                }
            }
        }
        finally {
            this.mainThreadPrefix = null;
            this.preInstantiationThread.remove();
        }
        for (String beanName : beanNames) {
            Object singletonInstance = this.getSingleton(beanName, false);
            if (!(singletonInstance instanceof SmartInitializingSingleton)) continue;
            SmartInitializingSingleton smartSingleton = (SmartInitializingSingleton)singletonInstance;
            StartupStep smartInitialize = this.getApplicationStartup().start("spring.beans.smart-initialize").tag("beanName", beanName);
            smartSingleton.afterSingletonsInstantiated();
            smartInitialize.end();
        }
    }

    @Nullable
    private CompletableFuture<?> preInstantiateSingleton(String beanName, RootBeanDefinition mbd) {
        if (mbd.isBackgroundInit()) {
            Executor executor = this.getBootstrapExecutor();
            if (executor != null) {
                String[] dependsOn = mbd.getDependsOn();
                if (dependsOn != null) {
                    for (String dep : dependsOn) {
                        this.getBean(dep);
                    }
                }
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.instantiateSingletonInBackgroundThread(beanName), executor);
                this.addSingletonFactory(beanName, () -> {
                    try {
                        future.join();
                    }
                    catch (CompletionException ex) {
                        ReflectionUtils.rethrowRuntimeException((Throwable)ex.getCause());
                    }
                    return future;
                });
                return !mbd.isLazyInit() ? future : null;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bean '" + beanName + "' marked for background initialization without bootstrap executor configured - falling back to mainline initialization"));
            }
        }
        if (!mbd.isLazyInit()) {
            try {
                this.instantiateSingleton(beanName);
            }
            catch (BeanCurrentlyInCreationException ex) {
                this.logger.info((Object)("Bean '" + beanName + "' marked for pre-instantiation (not lazy-init) but currently initialized by other thread - skipping it in mainline thread"));
            }
        }
        return null;
    }

    private void instantiateSingletonInBackgroundThread(String beanName) {
        this.preInstantiationThread.set((Object)PreInstantiation.BACKGROUND);
        try {
            this.instantiateSingleton(beanName);
        }
        catch (Error | RuntimeException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Failed to instantiate singleton bean '" + beanName + "' in background thread"), ex);
            }
            throw ex;
        }
        finally {
            this.preInstantiationThread.remove();
        }
    }

    private void instantiateSingleton(String beanName) {
        if (this.isFactoryBean(beanName)) {
            SmartFactoryBean smartFactoryBean;
            Object bean = this.getBean("&" + beanName);
            if (bean instanceof SmartFactoryBean && (smartFactoryBean = (SmartFactoryBean)bean).isEagerInit()) {
                this.getBean(beanName);
            }
        } else {
            this.getBean(beanName);
        }
    }

    private static String getThreadNamePrefix() {
        String name = Thread.currentThread().getName();
        int numberSeparator = name.lastIndexOf(45);
        return numberSeparator >= 0 ? name.substring(0, numberSeparator) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        BeanDefinition existingDefinition;
        Assert.hasText((String)beanName, (String)"Bean name must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition abd = (AbstractBeanDefinition)beanDefinition;
            try {
                abd.validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)((Object)ex));
            }
        }
        if ((existingDefinition = this.beanDefinitionMap.get(beanName)) != null) {
            if (!this.isBeanDefinitionOverridable(beanName)) {
                throw new BeanDefinitionOverrideException(beanName, beanDefinition, existingDefinition);
            }
            this.logBeanDefinitionOverriding(beanName, beanDefinition, existingDefinition);
            this.beanDefinitionMap.put(beanName, beanDefinition);
        } else {
            if (this.isAlias(beanName)) {
                String aliasedName = this.canonicalName(beanName);
                if (!this.isBeanDefinitionOverridable(aliasedName)) {
                    if (this.containsBeanDefinition(aliasedName)) {
                        throw new BeanDefinitionOverrideException(beanName, beanDefinition, this.getBeanDefinition(aliasedName));
                    }
                    throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition for bean '" + beanName + "' since there is already an alias for bean '" + aliasedName + "' bound.");
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Removing alias '" + beanName + "' for bean '" + aliasedName + "' due to registration of bean definition for bean '" + beanName + "': [" + String.valueOf(beanDefinition) + "]"));
                }
                this.removeAlias(beanName);
            }
            if (this.hasBeanCreationStarted()) {
                Map<String, BeanDefinition> map = this.beanDefinitionMap;
                synchronized (map) {
                    this.beanDefinitionMap.put(beanName, beanDefinition);
                    ArrayList<String> updatedDefinitions = new ArrayList<String>(this.beanDefinitionNames.size() + 1);
                    updatedDefinitions.addAll(this.beanDefinitionNames);
                    updatedDefinitions.add(beanName);
                    this.beanDefinitionNames = updatedDefinitions;
                    this.removeManualSingletonName(beanName);
                }
            } else {
                this.beanDefinitionMap.put(beanName, beanDefinition);
                this.beanDefinitionNames.add(beanName);
                this.removeManualSingletonName(beanName);
            }
            this.frozenBeanDefinitionNames = null;
        }
        if (existingDefinition != null || this.containsSingleton(beanName)) {
            this.resetBeanDefinition(beanName);
        } else if (this.isConfigurationFrozen()) {
            this.clearByTypeCache();
        }
        if (beanDefinition.isPrimary()) {
            this.primaryBeanNamesWithType.put(beanName, Void.class);
        }
    }

    private void logBeanDefinitionOverriding(String beanName, BeanDefinition beanDefinition, BeanDefinition existingDefinition) {
        boolean explicitBeanOverride;
        boolean bl = explicitBeanOverride = this.allowBeanDefinitionOverriding != null;
        if (existingDefinition.getRole() < beanDefinition.getRole()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding user-defined bean definition for bean '" + beanName + "' with a framework-generated bean definition: replacing [" + String.valueOf(existingDefinition) + "] with [" + String.valueOf(beanDefinition) + "]"));
            }
        } else if (!beanDefinition.equals(existingDefinition)) {
            if (explicitBeanOverride && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "' with a different definition: replacing [" + String.valueOf(existingDefinition) + "] with [" + String.valueOf(beanDefinition) + "]"));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Overriding bean definition for bean '" + beanName + "' with a different definition: replacing [" + String.valueOf(existingDefinition) + "] with [" + String.valueOf(beanDefinition) + "]"));
            }
        } else {
            if (explicitBeanOverride && this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "' with an equivalent definition: replacing [" + String.valueOf(existingDefinition) + "] with [" + String.valueOf(beanDefinition) + "]"));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Overriding bean definition for bean '" + beanName + "' with an equivalent definition: replacing [" + String.valueOf(existingDefinition) + "] with [" + String.valueOf(beanDefinition) + "]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        BeanDefinition bd = this.beanDefinitionMap.remove(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + String.valueOf(this)));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        if (this.hasBeanCreationStarted()) {
            Map<String, BeanDefinition> map = this.beanDefinitionMap;
            synchronized (map) {
                ArrayList<String> updatedDefinitions = new ArrayList<String>(this.beanDefinitionNames);
                updatedDefinitions.remove(beanName);
                this.beanDefinitionNames = updatedDefinitions;
            }
        } else {
            this.beanDefinitionNames.remove(beanName);
        }
        this.frozenBeanDefinitionNames = null;
        this.resetBeanDefinition(beanName);
    }

    protected void resetBeanDefinition(String beanName) {
        this.clearMergedBeanDefinition(beanName);
        this.destroySingleton(beanName);
        this.primaryBeanNamesWithType.remove(beanName);
        for (MergedBeanDefinitionPostProcessor processor : this.getBeanPostProcessorCache().mergedDefinition) {
            processor.resetBeanDefinition(beanName);
        }
        for (String bdName : this.beanDefinitionNames) {
            BeanDefinition bd;
            if (beanName.equals(bdName) || (bd = this.beanDefinitionMap.get(bdName)) == null || !beanName.equals(bd.getParentName())) continue;
            this.resetBeanDefinition(bdName);
        }
    }

    @Override
    public boolean isBeanDefinitionOverridable(String beanName) {
        return this.isAllowBeanDefinitionOverriding();
    }

    protected boolean allowAliasOverriding() {
        return this.isAllowBeanDefinitionOverriding();
    }

    protected void checkForAliasCircle(String name, String alias) {
        super.checkForAliasCircle(name, alias);
        if (!this.isBeanDefinitionOverridable(alias) && this.containsBeanDefinition(alias)) {
            throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "': Alias would override bean definition '" + alias + "'");
        }
    }

    @Override
    protected void addSingleton(String beanName, Object singletonObject) {
        super.addSingleton(beanName, singletonObject);
        Predicate<Class> filter = beanType -> beanType != Object.class && beanType.isInstance(singletonObject);
        this.allBeanNamesByType.keySet().removeIf(filter);
        this.singletonBeanNamesByType.keySet().removeIf(filter);
        if (this.primaryBeanNamesWithType.containsKey(beanName) && singletonObject.getClass() != NullBean.class) {
            Class<?> beanType2;
            if (singletonObject instanceof FactoryBean) {
                FactoryBean fb = (FactoryBean)singletonObject;
                v0 = this.getTypeForFactoryBean(fb);
            } else {
                v0 = beanType2 = singletonObject.getClass();
            }
            if (beanType2 != null) {
                this.primaryBeanNamesWithType.put(beanName, beanType2);
            }
        }
    }

    @Override
    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        super.registerSingleton(beanName, singletonObject);
        this.updateManualSingletonNames(set -> set.add(beanName), set -> !this.beanDefinitionMap.containsKey(beanName));
        this.allBeanNamesByType.remove(Object.class);
        this.singletonBeanNamesByType.remove(Object.class);
    }

    @Override
    public void destroySingletons() {
        super.destroySingletons();
        this.updateManualSingletonNames(Set::clear, set -> !set.isEmpty());
        this.clearByTypeCache();
    }

    @Override
    public void destroySingleton(String beanName) {
        super.destroySingleton(beanName);
        this.removeManualSingletonName(beanName);
        this.clearByTypeCache();
    }

    private void removeManualSingletonName(String beanName) {
        this.updateManualSingletonNames(set -> set.remove(beanName), set -> set.contains(beanName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManualSingletonNames(Consumer<Set<String>> action, Predicate<Set<String>> condition) {
        if (this.hasBeanCreationStarted()) {
            Map<String, BeanDefinition> map = this.beanDefinitionMap;
            synchronized (map) {
                if (condition.test(this.manualSingletonNames)) {
                    LinkedHashSet<String> updatedSingletons = new LinkedHashSet<String>(this.manualSingletonNames);
                    action.accept(updatedSingletons);
                    this.manualSingletonNames = updatedSingletons;
                }
            }
        } else if (condition.test(this.manualSingletonNames)) {
            action.accept(this.manualSingletonNames);
        }
    }

    private void clearByTypeCache() {
        this.allBeanNamesByType.clear();
        this.singletonBeanNamesByType.clear();
    }

    @Override
    public <T> NamedBeanHolder<T> resolveNamedBean(Class<T> requiredType) throws BeansException {
        Assert.notNull(requiredType, (String)"Required type must not be null");
        NamedBeanHolder<T> namedBean = this.resolveNamedBean(ResolvableType.forRawClass(requiredType), null, false);
        if (namedBean != null) {
            return namedBean;
        }
        BeanFactory parent = this.getParentBeanFactory();
        if (parent instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory acbf = (AutowireCapableBeanFactory)parent;
            return acbf.resolveNamedBean(requiredType);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    @Nullable
    private <T> NamedBeanHolder<T> resolveNamedBean(ResolvableType requiredType, @Nullable Object[] args, boolean nonUniqueAsNull) throws BeansException {
        Assert.notNull((Object)requiredType, (String)"Required type must not be null");
        String[] candidateNames = this.getBeanNamesForType(requiredType);
        if (candidateNames.length > 1) {
            ArrayList<String> autowireCandidates = new ArrayList<String>(candidateNames.length);
            for (String beanName : candidateNames) {
                if (this.containsBeanDefinition(beanName) && !this.getBeanDefinition(beanName).isAutowireCandidate()) continue;
                autowireCandidates.add(beanName);
            }
            if (!autowireCandidates.isEmpty()) {
                candidateNames = StringUtils.toStringArray(autowireCandidates);
            }
        }
        if (candidateNames.length == 1) {
            return this.resolveNamedBean(candidateNames[0], requiredType, args);
        }
        if (candidateNames.length > 1) {
            LinkedHashMap candidates = CollectionUtils.newLinkedHashMap((int)candidateNames.length);
            for (String beanName : candidateNames) {
                if (this.containsSingleton(beanName) && args == null) {
                    Object beanInstance = this.getBean(beanName);
                    candidates.put(beanName, beanInstance instanceof NullBean ? null : beanInstance);
                    continue;
                }
                candidates.put(beanName, this.getType(beanName));
            }
            String candidateName = this.determinePrimaryCandidate(candidates, requiredType.toClass());
            if (candidateName == null) {
                candidateName = this.determineHighestPriorityCandidate(candidates, requiredType.toClass());
            }
            if (candidateName == null) {
                candidateName = this.determineDefaultCandidate(candidates);
            }
            if (candidateName != null) {
                Object beanInstance = candidates.get(candidateName);
                if (beanInstance == null) {
                    return null;
                }
                if (beanInstance instanceof Class) {
                    return this.resolveNamedBean(candidateName, requiredType, args);
                }
                return new NamedBeanHolder(candidateName, beanInstance);
            }
            if (!nonUniqueAsNull) {
                throw new NoUniqueBeanDefinitionException(requiredType, candidates.keySet());
            }
        }
        return null;
    }

    @Nullable
    private <T> NamedBeanHolder<T> resolveNamedBean(String beanName, ResolvableType requiredType, @Nullable Object[] args) throws BeansException {
        Object bean = this.getBean(beanName, null, args);
        if (bean instanceof NullBean) {
            return null;
        }
        return new NamedBeanHolder(beanName, this.adaptBeanInstance(beanName, bean, requiredType.toClass()));
    }

    @Override
    @Nullable
    public Object resolveDependency(DependencyDescriptor descriptor, @Nullable String requestingBeanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) throws BeansException {
        Object result;
        descriptor.initParameterNameDiscovery(this.getParameterNameDiscoverer());
        if (Optional.class == descriptor.getDependencyType()) {
            return this.createOptionalDependency(descriptor, requestingBeanName, new Object[0]);
        }
        if (ObjectFactory.class == descriptor.getDependencyType() || ObjectProvider.class == descriptor.getDependencyType()) {
            return new DependencyObjectProvider(descriptor, requestingBeanName);
        }
        if (jakartaInjectProviderClass == descriptor.getDependencyType()) {
            return new Jsr330Factory().createDependencyProvider(descriptor, requestingBeanName);
        }
        if (descriptor.supportsLazyResolution() && (result = this.getAutowireCandidateResolver().getLazyResolutionProxyIfNecessary(descriptor, requestingBeanName)) != null) {
            return result;
        }
        return this.doResolveDependency(descriptor, requestingBeanName, autowiredBeanNames, typeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    public Object doResolveDependency(DependencyDescriptor descriptor, @Nullable String beanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) throws BeansException {
        InjectionPoint previousInjectionPoint = ConstructorResolver.setCurrentInjectionPoint(descriptor);
        try {
            Object instanceCandidate;
            String autowiredBeanName;
            Object multipleBeans;
            Object shortcut = descriptor.resolveShortcut(this);
            if (shortcut != null) {
                Object object = shortcut;
                return object;
            }
            Class<?> type = descriptor.getDependencyType();
            Object value = this.getAutowireCandidateResolver().getSuggestedValue(descriptor);
            if (value != null) {
                BeanDefinition bd;
                String resolvedValue;
                if (value instanceof String) {
                    String strValue = (String)value;
                    resolvedValue = this.resolveEmbeddedValue(strValue);
                    bd = beanName != null && this.containsBean(beanName) ? this.getMergedBeanDefinition(beanName) : null;
                    value = this.evaluateBeanDefinitionString(resolvedValue, bd);
                }
                TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
                try {
                    resolvedValue = converter.convertIfNecessary(value, type, descriptor.getTypeDescriptor());
                    return resolvedValue;
                }
                catch (UnsupportedOperationException ex) {
                    bd = descriptor.getField() != null ? converter.convertIfNecessary(value, type, descriptor.getField()) : converter.convertIfNecessary(value, type, descriptor.getMethodParameter());
                    ConstructorResolver.setCurrentInjectionPoint(previousInjectionPoint);
                    return bd;
                }
            }
            if (descriptor.usesStandardBeanLookup()) {
                String dependencyName = descriptor.getDependencyName();
                if (dependencyName == null || !this.containsBean(dependencyName)) {
                    String suggestedName = this.getAutowireCandidateResolver().getSuggestedName(descriptor);
                    String string = dependencyName = suggestedName != null && this.containsBean(suggestedName) ? suggestedName : null;
                }
                if (dependencyName != null && this.isTypeMatch(dependencyName = this.canonicalName(dependencyName), type) && this.isAutowireCandidate(dependencyName, descriptor) && !this.isFallback(dependencyName) && !this.hasPrimaryConflict(dependencyName, type) && !this.isSelfReference(beanName, dependencyName)) {
                    if (autowiredBeanNames != null) {
                        autowiredBeanNames.add(dependencyName);
                    }
                    boolean preExisting = this.containsSingleton(dependencyName);
                    Object dependencyBean = this.getBean(dependencyName);
                    if (preExisting && dependencyBean instanceof NullBean) {
                        dependencyBean = null;
                    }
                    Object object = this.resolveInstance(dependencyBean, descriptor, type, dependencyName);
                    return object;
                }
            }
            if ((multipleBeans = this.resolveMultipleBeans(descriptor, beanName, autowiredBeanNames, typeConverter)) != null) {
                Object preExisting = multipleBeans;
                return preExisting;
            }
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, type, descriptor);
            if (matchingBeans.isEmpty()) {
                multipleBeans = this.resolveMultipleBeansFallback(descriptor, beanName, autowiredBeanNames, typeConverter);
                if (multipleBeans != null) {
                    Object dependencyBean = multipleBeans;
                    return dependencyBean;
                }
                if (this.isRequired(descriptor)) {
                    this.raiseNoMatchingBeanFound(type, descriptor.getResolvableType(), descriptor);
                }
                Object dependencyBean = null;
                return dependencyBean;
            }
            if (matchingBeans.size() > 1) {
                autowiredBeanName = this.determineAutowireCandidate(matchingBeans, descriptor);
                if (autowiredBeanName == null) {
                    if (this.isRequired(descriptor) || !this.indicatesArrayCollectionOrMap(type)) {
                        Object object = descriptor.resolveNotUnique(descriptor.getResolvableType(), matchingBeans);
                        return object;
                    }
                    Object var13_24 = null;
                    return var13_24;
                }
                instanceCandidate = matchingBeans.get(autowiredBeanName);
            } else {
                Map.Entry<String, Object> entry = matchingBeans.entrySet().iterator().next();
                autowiredBeanName = entry.getKey();
                instanceCandidate = entry.getValue();
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.add(autowiredBeanName);
            }
            if (instanceCandidate instanceof Class) {
                instanceCandidate = descriptor.resolveCandidate(autowiredBeanName, type, this);
            }
            Object object = this.resolveInstance(instanceCandidate, descriptor, type, autowiredBeanName);
            return object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConstructorResolver.setCurrentInjectionPoint(previousInjectionPoint);
        }
    }

    @Nullable
    private Object resolveInstance(Object candidate, DependencyDescriptor descriptor, Class<?> type, String name) {
        Object result = candidate;
        if (result instanceof NullBean) {
            if (this.isRequired(descriptor)) {
                this.raiseNoMatchingBeanFound(type, descriptor.getResolvableType(), descriptor);
            }
            result = null;
        }
        if (!ClassUtils.isAssignableValue(type, (Object)result)) {
            throw new BeanNotOfRequiredTypeException(name, type, candidate.getClass());
        }
        return result;
    }

    @Nullable
    private Object resolveMultipleBeans(DependencyDescriptor descriptor, @Nullable String beanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) {
        Class<?> type = descriptor.getDependencyType();
        if (descriptor instanceof StreamDependencyDescriptor) {
            StreamDependencyDescriptor streamDependencyDescriptor = (StreamDependencyDescriptor)descriptor;
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, type, descriptor);
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            Stream<Object> stream = matchingBeans.keySet().stream().map(name -> descriptor.resolveCandidate((String)name, type, this)).filter(bean -> !(bean instanceof NullBean));
            if (streamDependencyDescriptor.isOrdered()) {
                stream = stream.sorted(this.adaptOrderComparator(matchingBeans));
            }
            return stream;
        }
        if (type.isArray()) {
            Comparator<Object> comparator;
            Object[] array;
            TypeConverter converter;
            Object result;
            TypeDescriptor.OfField componentType = type.componentType();
            ResolvableType resolvableType = descriptor.getResolvableType();
            Class resolvedArrayType = resolvableType.resolve(type);
            if (resolvedArrayType != type) {
                componentType = resolvableType.getComponentType().resolve();
            }
            if (componentType == null) {
                return null;
            }
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, (Class<?>)componentType, new MultiElementDescriptor(descriptor));
            if (matchingBeans.isEmpty()) {
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            if ((result = (converter = typeConverter != null ? typeConverter : this.getTypeConverter()).convertIfNecessary(matchingBeans.values(), resolvedArrayType)) instanceof Object[] && (array = (Object[])result).length > 1 && (comparator = this.adaptDependencyComparator(matchingBeans)) != null) {
                Arrays.sort(array, comparator);
            }
            return result;
        }
        if (Collection.class == type || Set.class == type || List.class == type) {
            return this.resolveMultipleBeanCollection(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        if (Map.class == type) {
            return this.resolveMultipleBeanMap(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        return null;
    }

    @Nullable
    private Object resolveMultipleBeansFallback(DependencyDescriptor descriptor, @Nullable String beanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) {
        Class<?> type = descriptor.getDependencyType();
        if (Collection.class.isAssignableFrom(type) && type.isInterface()) {
            return this.resolveMultipleBeanCollection(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        if (Map.class.isAssignableFrom(type) && type.isInterface()) {
            return this.resolveMultipleBeanMap(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        return null;
    }

    @Nullable
    private Object resolveMultipleBeanCollection(DependencyDescriptor descriptor, @Nullable String beanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) {
        Comparator<Object> comparator;
        List list;
        TypeConverter converter;
        Object result;
        Class elementType = descriptor.getResolvableType().asCollection().resolveGeneric(new int[0]);
        if (elementType == null) {
            return null;
        }
        Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, elementType, new MultiElementDescriptor(descriptor));
        if (matchingBeans.isEmpty()) {
            return null;
        }
        if (autowiredBeanNames != null) {
            autowiredBeanNames.addAll(matchingBeans.keySet());
        }
        if ((result = (converter = typeConverter != null ? typeConverter : this.getTypeConverter()).convertIfNecessary(matchingBeans.values(), descriptor.getDependencyType())) instanceof List && (list = (List)result).size() > 1 && (comparator = this.adaptDependencyComparator(matchingBeans)) != null) {
            list.sort(comparator);
        }
        return result;
    }

    @Nullable
    private Object resolveMultipleBeanMap(DependencyDescriptor descriptor, @Nullable String beanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) {
        ResolvableType mapType = descriptor.getResolvableType().asMap();
        Class keyType = mapType.resolveGeneric(new int[]{0});
        if (String.class != keyType) {
            return null;
        }
        Class valueType = mapType.resolveGeneric(new int[]{1});
        if (valueType == null) {
            return null;
        }
        Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, valueType, new MultiElementDescriptor(descriptor));
        if (matchingBeans.isEmpty()) {
            return null;
        }
        if (autowiredBeanNames != null) {
            autowiredBeanNames.addAll(matchingBeans.keySet());
        }
        TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
        return converter.convertIfNecessary(matchingBeans, descriptor.getDependencyType());
    }

    private boolean indicatesArrayCollectionOrMap(Class<?> type) {
        return type.isArray() || type.isInterface() && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
    }

    private boolean isRequired(DependencyDescriptor descriptor) {
        return this.getAutowireCandidateResolver().isRequired(descriptor);
    }

    @Nullable
    private Comparator<Object> adaptDependencyComparator(Map<String, ?> matchingBeans) {
        Comparator<Object> comparator = this.getDependencyComparator();
        if (comparator instanceof OrderComparator) {
            OrderComparator orderComparator = (OrderComparator)comparator;
            return orderComparator.withSourceProvider(this.createFactoryAwareOrderSourceProvider(matchingBeans));
        }
        return comparator;
    }

    private Comparator<Object> adaptOrderComparator(Map<String, ?> matchingBeans) {
        OrderComparator orderComparator;
        Comparator<Object> dependencyComparator = this.getDependencyComparator();
        OrderComparator comparator = dependencyComparator instanceof OrderComparator ? (orderComparator = (OrderComparator)dependencyComparator) : OrderComparator.INSTANCE;
        return comparator.withSourceProvider(this.createFactoryAwareOrderSourceProvider(matchingBeans));
    }

    private OrderComparator.OrderSourceProvider createFactoryAwareOrderSourceProvider(Map<String, ?> beans) {
        IdentityHashMap<Object, String> instancesToBeanNames = new IdentityHashMap<Object, String>();
        beans.forEach((beanName, instance) -> instancesToBeanNames.put(instance, (String)beanName));
        return new FactoryAwareOrderSourceProvider(instancesToBeanNames);
    }

    protected Map<String, Object> findAutowireCandidates(@Nullable String beanName, Class<?> requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this, requiredType, true, descriptor.isEager());
        LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)candidateNames.length);
        for (Map.Entry<Class<?>, Object> classObjectEntry : this.resolvableDependencies.entrySet()) {
            Class<?> autowiringType = classObjectEntry.getKey();
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            Object autowiringValue = classObjectEntry.getValue();
            if (!requiredType.isInstance(autowiringValue = AutowireUtils.resolveAutowiringValue(autowiringValue, requiredType))) continue;
            result.put(ObjectUtils.identityToString((Object)autowiringValue), autowiringValue);
            break;
        }
        for (String candidate : candidateNames) {
            if (this.isSelfReference(beanName, candidate) || !this.isAutowireCandidate(candidate, descriptor)) continue;
            this.addCandidateEntry(result, candidate, descriptor, requiredType);
        }
        if (result.isEmpty()) {
            boolean multiple = this.indicatesArrayCollectionOrMap(requiredType);
            DependencyDescriptor fallbackDescriptor = descriptor.forFallbackMatch();
            for (String candidate : candidateNames) {
                if (this.isSelfReference(beanName, candidate) || !this.isAutowireCandidate(candidate, fallbackDescriptor) || multiple && !this.getAutowireCandidateResolver().hasQualifier(descriptor)) continue;
                this.addCandidateEntry(result, candidate, descriptor, requiredType);
            }
            if (result.isEmpty() && !multiple) {
                for (String candidate : candidateNames) {
                    if (!this.isSelfReference(beanName, candidate) || descriptor instanceof MultiElementDescriptor && beanName.equals(candidate) || !this.isAutowireCandidate(candidate, fallbackDescriptor)) continue;
                    this.addCandidateEntry(result, candidate, descriptor, requiredType);
                }
            }
        }
        return result;
    }

    private void addCandidateEntry(Map<String, Object> candidates, String candidateName, DependencyDescriptor descriptor, Class<?> requiredType) {
        StreamDependencyDescriptor streamDescriptor;
        if (descriptor instanceof MultiElementDescriptor) {
            Object beanInstance = descriptor.resolveCandidate(candidateName, requiredType, this);
            if (!(beanInstance instanceof NullBean)) {
                candidates.put(candidateName, beanInstance);
            }
        } else if (this.containsSingleton(candidateName) || descriptor instanceof StreamDependencyDescriptor && (streamDescriptor = (StreamDependencyDescriptor)descriptor).isOrdered()) {
            Object beanInstance = descriptor.resolveCandidate(candidateName, requiredType, this);
            candidates.put(candidateName, beanInstance instanceof NullBean ? null : beanInstance);
        } else {
            candidates.put(candidateName, this.getType(candidateName));
        }
    }

    @Nullable
    protected String determineAutowireCandidate(Map<String, Object> candidates, DependencyDescriptor descriptor) {
        String string;
        String suggestedName;
        Class<?> requiredType = descriptor.getDependencyType();
        String primaryCandidate = this.determinePrimaryCandidate(candidates, requiredType);
        if (primaryCandidate != null) {
            return primaryCandidate;
        }
        String dependencyName = descriptor.getDependencyName();
        if (dependencyName != null) {
            for (String string2 : candidates.keySet()) {
                if (!this.matchesBeanName(string2, dependencyName)) continue;
                return string2;
            }
        }
        if ((suggestedName = this.getAutowireCandidateResolver().getSuggestedName(descriptor)) != null) {
            for (String beanName : candidates.keySet()) {
                if (!this.matchesBeanName(beanName, suggestedName)) continue;
                return beanName;
            }
        }
        if ((string = this.determineHighestPriorityCandidate(candidates, requiredType)) != null) {
            return string;
        }
        String defaultCandidate = this.determineDefaultCandidate(candidates);
        if (defaultCandidate != null) {
            return defaultCandidate;
        }
        for (Map.Entry<String, Object> entry : candidates.entrySet()) {
            String candidateName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance == null || !this.resolvableDependencies.containsValue(beanInstance)) continue;
            return candidateName;
        }
        return null;
    }

    @Nullable
    protected String determinePrimaryCandidate(Map<String, Object> candidates, Class<?> requiredType) {
        String primaryBeanName = null;
        for (Map.Entry<String, Object> entry : candidates.entrySet()) {
            Object beanInstance;
            String candidateBeanName = entry.getKey();
            if (!this.isPrimary(candidateBeanName, beanInstance = entry.getValue())) continue;
            if (primaryBeanName != null) {
                boolean primaryLocal;
                boolean candidateLocal = this.containsBeanDefinition(candidateBeanName);
                if (candidateLocal == (primaryLocal = this.containsBeanDefinition(primaryBeanName))) {
                    String message = "more than one 'primary' bean found among candidates: " + String.valueOf(candidates.keySet());
                    this.logger.trace((Object)message);
                    throw new NoUniqueBeanDefinitionException(requiredType, candidates.size(), message);
                }
                if (!candidateLocal) continue;
                primaryBeanName = candidateBeanName;
                continue;
            }
            primaryBeanName = candidateBeanName;
        }
        if (primaryBeanName == null) {
            for (String candidateBeanName : candidates.keySet()) {
                if (this.isFallback(candidateBeanName)) continue;
                if (primaryBeanName != null) {
                    return null;
                }
                primaryBeanName = candidateBeanName;
            }
        }
        return primaryBeanName;
    }

    @Nullable
    protected String determineHighestPriorityCandidate(Map<String, Object> candidates, Class<?> requiredType) {
        String highestPriorityBeanName = null;
        Integer highestPriority = null;
        boolean highestPriorityConflictDetected = false;
        for (Map.Entry<String, Object> entry : candidates.entrySet()) {
            Integer candidatePriority;
            String candidateBeanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance == null || (candidatePriority = this.getPriority(beanInstance)) == null) continue;
            if (highestPriority != null) {
                if (candidatePriority.equals(highestPriority)) {
                    highestPriorityConflictDetected = true;
                    continue;
                }
                if (candidatePriority >= highestPriority) continue;
                highestPriorityBeanName = candidateBeanName;
                highestPriority = candidatePriority;
                highestPriorityConflictDetected = false;
                continue;
            }
            highestPriorityBeanName = candidateBeanName;
            highestPriority = candidatePriority;
        }
        if (highestPriorityConflictDetected) {
            throw new NoUniqueBeanDefinitionException(requiredType, candidates.size(), "Multiple beans found with the same highest priority (" + highestPriority + ") among candidates: " + String.valueOf(candidates.keySet()));
        }
        return highestPriorityBeanName;
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        DefaultListableBeanFactory parent;
        String transformedBeanName = this.transformedBeanName(beanName);
        if (this.containsBeanDefinition(transformedBeanName)) {
            return this.getMergedLocalBeanDefinition(transformedBeanName).isPrimary();
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        return beanFactory instanceof DefaultListableBeanFactory && (parent = (DefaultListableBeanFactory)beanFactory).isPrimary(transformedBeanName, beanInstance);
    }

    private boolean isFallback(String beanName) {
        DefaultListableBeanFactory parent;
        String transformedBeanName = this.transformedBeanName(beanName);
        if (this.containsBeanDefinition(transformedBeanName)) {
            return this.getMergedLocalBeanDefinition(transformedBeanName).isFallback();
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        return beanFactory instanceof DefaultListableBeanFactory && (parent = (DefaultListableBeanFactory)beanFactory).isFallback(transformedBeanName);
    }

    @Nullable
    protected Integer getPriority(Object beanInstance) {
        Comparator<Object> comparator = this.getDependencyComparator();
        if (comparator instanceof OrderComparator) {
            OrderComparator orderComparator = (OrderComparator)comparator;
            return orderComparator.getPriority(beanInstance);
        }
        return null;
    }

    @Nullable
    private String determineDefaultCandidate(Map<String, Object> candidates) {
        String defaultBeanName = null;
        for (String candidateBeanName : candidates.keySet()) {
            if (!AutowireUtils.isDefaultCandidate(this, candidateBeanName)) continue;
            if (defaultBeanName != null) {
                return null;
            }
            defaultBeanName = candidateBeanName;
        }
        return defaultBeanName;
    }

    protected boolean matchesBeanName(String beanName, @Nullable String candidateName) {
        return candidateName != null && (candidateName.equals(beanName) || ObjectUtils.containsElement((Object[])this.getAliases(beanName), (Object)candidateName));
    }

    @Contract(value="null, _ -> false; _, null -> false;")
    private boolean isSelfReference(@Nullable String beanName, @Nullable String candidateName) {
        return beanName != null && candidateName != null && (beanName.equals(candidateName) || this.containsBeanDefinition(candidateName) && beanName.equals(this.getMergedLocalBeanDefinition(candidateName).getFactoryBeanName()));
    }

    private boolean hasPrimaryConflict(String beanName, Class<?> dependencyType) {
        DefaultListableBeanFactory parent;
        for (Map.Entry<String, Class<?>> candidate : this.primaryBeanNamesWithType.entrySet()) {
            String candidateName = candidate.getKey();
            Class<?> candidateType = candidate.getValue();
            if (candidateName.equals(beanName) || !(candidateType != Void.class ? dependencyType.isAssignableFrom(candidateType) : this.isTypeMatch(candidateName, dependencyType))) continue;
            return true;
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        return beanFactory instanceof DefaultListableBeanFactory && (parent = (DefaultListableBeanFactory)beanFactory).hasPrimaryConflict(beanName, dependencyType);
    }

    private void raiseNoMatchingBeanFound(Class<?> type, ResolvableType resolvableType, DependencyDescriptor descriptor) throws BeansException {
        this.checkBeanNotOfRequiredType(type, descriptor);
        throw new NoSuchBeanDefinitionException(resolvableType, "expected at least 1 bean which qualifies as autowire candidate. Dependency annotations: " + ObjectUtils.nullSafeToString((Object[])descriptor.getAnnotations()));
    }

    private void checkBeanNotOfRequiredType(Class<?> type, DependencyDescriptor descriptor) {
        for (String beanName : this.beanDefinitionNames) {
            try {
                Object beanInstance;
                Class<?> beanType;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                Class<?> targetType = mbd.getTargetType();
                if (targetType == null || !type.isAssignableFrom(targetType) || !this.isAutowireCandidate(beanName, mbd, descriptor, this.getAutowireCandidateResolver()) || (beanType = (beanInstance = this.getSingleton(beanName, false)) != null && beanInstance.getClass() != NullBean.class ? beanInstance.getClass() : this.predictBeanType(beanName, mbd, new Class[0])) == null || type.isAssignableFrom(beanType)) continue;
                throw new BeanNotOfRequiredTypeException(beanName, type, beanType);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            }
        }
        BeanFactory beanFactory = this.getParentBeanFactory();
        if (beanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory parent = (DefaultListableBeanFactory)beanFactory;
            parent.checkBeanNotOfRequiredType(type, descriptor);
        }
    }

    private Optional<?> createOptionalDependency(DependencyDescriptor descriptor, @Nullable String beanName, final Object ... args) {
        Optional optional;
        NestedDependencyDescriptor descriptorToUse = new NestedDependencyDescriptor(descriptor){

            @Override
            public boolean isRequired() {
                return false;
            }

            @Override
            public Object resolveCandidate(String beanName, Class<?> requiredType, BeanFactory beanFactory) {
                return !ObjectUtils.isEmpty((Object[])args) ? beanFactory.getBean(beanName, args) : super.resolveCandidate(beanName, requiredType, beanFactory);
            }

            @Override
            public boolean usesStandardBeanLookup() {
                return ObjectUtils.isEmpty((Object[])args);
            }
        };
        Object result = this.doResolveDependency(descriptorToUse, beanName, null, null);
        return result instanceof Optional ? (optional = (Optional)result) : Optional.ofNullable(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ObjectUtils.identityToString((Object)this));
        sb.append(": defining beans [");
        sb.append(StringUtils.collectionToCommaDelimitedString(this.beanDefinitionNames));
        sb.append("]; ");
        BeanFactory parent = this.getParentBeanFactory();
        if (parent == null) {
            sb.append("root of factory hierarchy");
        } else {
            sb.append("parent: ").append(ObjectUtils.identityToString((Object)parent));
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("DefaultListableBeanFactory itself is not deserializable - just a SerializedBeanFactoryReference is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.serializationId != null) {
            return new SerializedBeanFactoryReference(this.serializationId);
        }
        throw new NotSerializableException("DefaultListableBeanFactory has no serialization id");
    }

    static {
        try {
            jakartaInjectProviderClass = ClassUtils.forName((String)"jakarta.inject.Provider", (ClassLoader)DefaultListableBeanFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            jakartaInjectProviderClass = null;
        }
        serializableFactories = new ConcurrentHashMap<String, Reference<DefaultListableBeanFactory>>(8);
    }

    private static enum PreInstantiation {
        MAIN,
        BACKGROUND;

    }

    private class DependencyObjectProvider
    implements BeanObjectProvider<Object> {
        private final DependencyDescriptor descriptor;
        private final boolean optional;
        @Nullable
        private final String beanName;

        public DependencyObjectProvider(@Nullable DependencyDescriptor descriptor, String beanName) {
            this.descriptor = new NestedDependencyDescriptor(descriptor);
            this.optional = this.descriptor.getDependencyType() == Optional.class;
            this.beanName = beanName;
        }

        @Override
        public Object getObject() throws BeansException {
            if (this.optional) {
                return DefaultListableBeanFactory.this.createOptionalDependency(this.descriptor, this.beanName, new Object[0]);
            }
            Object result = DefaultListableBeanFactory.this.doResolveDependency(this.descriptor, this.beanName, null, null);
            if (result == null) {
                throw new NoSuchBeanDefinitionException(this.descriptor.getResolvableType());
            }
            return result;
        }

        @Override
        public Object getObject(final Object ... args) throws BeansException {
            if (this.optional) {
                return DefaultListableBeanFactory.this.createOptionalDependency(this.descriptor, this.beanName, args);
            }
            DependencyDescriptor descriptorToUse = new DependencyDescriptor(this.descriptor){

                @Override
                public Object resolveCandidate(String beanName, Class<?> requiredType, BeanFactory beanFactory) {
                    return beanFactory.getBean(beanName, args);
                }
            };
            Object result = DefaultListableBeanFactory.this.doResolveDependency(descriptorToUse, this.beanName, null, null);
            if (result == null) {
                throw new NoSuchBeanDefinitionException(this.descriptor.getResolvableType());
            }
            return result;
        }

        @Override
        @Nullable
        public Object getIfAvailable() throws BeansException {
            try {
                if (this.optional) {
                    return DefaultListableBeanFactory.this.createOptionalDependency(this.descriptor, this.beanName, new Object[0]);
                }
                DependencyDescriptor descriptorToUse = new DependencyDescriptor(this.descriptor){

                    @Override
                    public boolean isRequired() {
                        return false;
                    }

                    @Override
                    public boolean usesStandardBeanLookup() {
                        return true;
                    }
                };
                return DefaultListableBeanFactory.this.doResolveDependency(descriptorToUse, this.beanName, null, null);
            }
            catch (ScopeNotActiveException ex) {
                return null;
            }
        }

        @Override
        public void ifAvailable(Consumer<Object> dependencyConsumer) throws BeansException {
            Object dependency = this.getIfAvailable();
            if (dependency != null) {
                try {
                    dependencyConsumer.accept(dependency);
                }
                catch (ScopeNotActiveException scopeNotActiveException) {
                    // empty catch block
                }
            }
        }

        @Override
        @Nullable
        public Object getIfUnique() throws BeansException {
            DependencyDescriptor descriptorToUse = new DependencyDescriptor(this.descriptor){

                @Override
                public boolean isRequired() {
                    return false;
                }

                @Override
                public boolean usesStandardBeanLookup() {
                    return true;
                }

                @Override
                @Nullable
                public Object resolveNotUnique(ResolvableType type, Map<String, Object> matchingBeans) {
                    return null;
                }
            };
            try {
                if (this.optional) {
                    return DefaultListableBeanFactory.this.createOptionalDependency(descriptorToUse, this.beanName, new Object[0]);
                }
                return DefaultListableBeanFactory.this.doResolveDependency(descriptorToUse, this.beanName, null, null);
            }
            catch (ScopeNotActiveException ex) {
                return null;
            }
        }

        @Override
        public void ifUnique(Consumer<Object> dependencyConsumer) throws BeansException {
            Object dependency = this.getIfUnique();
            if (dependency != null) {
                try {
                    dependencyConsumer.accept(dependency);
                }
                catch (ScopeNotActiveException scopeNotActiveException) {
                    // empty catch block
                }
            }
        }

        @Nullable
        protected Object getValue() throws BeansException {
            if (this.optional) {
                return DefaultListableBeanFactory.this.createOptionalDependency(this.descriptor, this.beanName, new Object[0]);
            }
            return DefaultListableBeanFactory.this.doResolveDependency(this.descriptor, this.beanName, null, null);
        }

        @Override
        public Stream<Object> stream() {
            return this.resolveStream(false);
        }

        @Override
        public Stream<Object> orderedStream() {
            return this.resolveStream(true);
        }

        private Stream<Object> resolveStream(boolean ordered) {
            Stream stream;
            StreamDependencyDescriptor descriptorToUse = new StreamDependencyDescriptor(this.descriptor, ordered);
            Object result = DefaultListableBeanFactory.this.doResolveDependency(descriptorToUse, this.beanName, null, null);
            return result instanceof Stream ? (stream = (Stream)result) : Stream.of(result);
        }

        @Override
        public Stream<Object> stream(Predicate<Class<?>> customFilter, boolean includeNonSingletons) {
            return Arrays.stream(DefaultListableBeanFactory.this.beanNamesForStream(this.descriptor.getResolvableType(), includeNonSingletons, true)).filter(name -> AutowireUtils.isAutowireCandidate(DefaultListableBeanFactory.this, name)).filter(name -> customFilter.test(DefaultListableBeanFactory.this.getType((String)name))).map(name -> DefaultListableBeanFactory.this.getBean((String)name)).filter(bean -> !(bean instanceof NullBean));
        }

        @Override
        public Stream<Object> orderedStream(Predicate<Class<?>> customFilter, boolean includeNonSingletons) {
            String[] beanNames = DefaultListableBeanFactory.this.beanNamesForStream(this.descriptor.getResolvableType(), includeNonSingletons, true);
            if (beanNames.length == 0) {
                return Stream.empty();
            }
            LinkedHashMap matchingBeans = CollectionUtils.newLinkedHashMap((int)beanNames.length);
            for (String beanName : beanNames) {
                Object beanInstance;
                if (!AutowireUtils.isAutowireCandidate(DefaultListableBeanFactory.this, beanName) || !customFilter.test(DefaultListableBeanFactory.this.getType(beanName)) || (beanInstance = DefaultListableBeanFactory.this.getBean(beanName)) instanceof NullBean) continue;
                matchingBeans.put(beanName, beanInstance);
            }
            return matchingBeans.values().stream().sorted(DefaultListableBeanFactory.this.adaptOrderComparator(matchingBeans));
        }
    }

    private class Jsr330Factory
    implements Serializable {
        private Jsr330Factory() {
        }

        public Object createDependencyProvider(DependencyDescriptor descriptor, @Nullable String beanName) {
            return new Jsr330Provider(descriptor, beanName);
        }

        private class Jsr330Provider
        extends DependencyObjectProvider
        implements Provider<Object> {
            public Jsr330Provider(@Nullable DependencyDescriptor descriptor, String beanName) {
                super(descriptor, beanName);
            }

            @Nullable
            public Object get() throws BeansException {
                return this.getValue();
            }
        }
    }

    private static class StreamDependencyDescriptor
    extends DependencyDescriptor {
        private final boolean ordered;

        public StreamDependencyDescriptor(DependencyDescriptor original, boolean ordered) {
            super(original);
            this.ordered = ordered;
        }

        public boolean isOrdered() {
            return this.ordered;
        }
    }

    private static class MultiElementDescriptor
    extends NestedDependencyDescriptor {
        public MultiElementDescriptor(DependencyDescriptor original) {
            super(original);
        }
    }

    private class FactoryAwareOrderSourceProvider
    implements OrderComparator.OrderSourceProvider {
        private final Map<Object, String> instancesToBeanNames;

        public FactoryAwareOrderSourceProvider(Map<Object, String> instancesToBeanNames) {
            this.instancesToBeanNames = instancesToBeanNames;
        }

        @Nullable
        public Object getOrderSource(Object obj) {
            String beanName = this.instancesToBeanNames.get(obj);
            if (beanName == null) {
                return null;
            }
            try {
                BeanDefinition beanDefinition = DefaultListableBeanFactory.this.getMergedBeanDefinition(beanName);
                ArrayList<Object> sources = new ArrayList<Object>(3);
                Object orderAttribute = beanDefinition.getAttribute("order");
                if (orderAttribute != null) {
                    if (orderAttribute instanceof Integer) {
                        Integer order = (Integer)orderAttribute;
                        sources.add(() -> order);
                    } else {
                        throw new IllegalStateException("Invalid value type for attribute 'order': " + orderAttribute.getClass().getName());
                    }
                }
                if (beanDefinition instanceof RootBeanDefinition) {
                    Class<?> targetType;
                    RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
                    Method factoryMethod = rootBeanDefinition.getResolvedFactoryMethod();
                    if (factoryMethod != null) {
                        sources.add(factoryMethod);
                    }
                    if ((targetType = rootBeanDefinition.getTargetType()) != null && targetType != obj.getClass()) {
                        sources.add(targetType);
                    }
                }
                return sources.toArray();
            }
            catch (NoSuchBeanDefinitionException ex) {
                return null;
            }
        }
    }

    private static class SerializedBeanFactoryReference
    implements Serializable {
        private final String id;

        public SerializedBeanFactoryReference(String id) {
            this.id = id;
        }

        private Object readResolve() {
            DefaultListableBeanFactory result;
            Reference<DefaultListableBeanFactory> ref = serializableFactories.get(this.id);
            if (ref != null && (result = ref.get()) != null) {
                return result;
            }
            DefaultListableBeanFactory dummyFactory = new DefaultListableBeanFactory();
            dummyFactory.serializationId = this.id;
            return dummyFactory;
        }
    }

    private static interface BeanObjectProvider<T>
    extends ObjectProvider<T>,
    Serializable {
    }

    private static class NestedDependencyDescriptor
    extends DependencyDescriptor {
        public NestedDependencyDescriptor(DependencyDescriptor original) {
            super(original);
            this.increaseNestingLevel();
        }

        @Override
        public boolean usesStandardBeanLookup() {
            return true;
        }
    }
}

