/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.OneForOneStrategy;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.SupervisorStrategy$;
import org.apache.pekko.actor.TypedCreatorFunctionConsumer;
import org.apache.pekko.pattern.AutoReset;
import org.apache.pekko.pattern.BackoffOnFailureOptions;
import org.apache.pekko.pattern.BackoffOnStopOptions;
import org.apache.pekko.pattern.BackoffOptions;
import org.apache.pekko.pattern.BackoffSupervisor$GetCurrentChild$;
import org.apache.pekko.pattern.BackoffSupervisor$GetRestartCount$;
import org.apache.pekko.pattern.BackoffSupervisor$Reset$;
import org.apache.pekko.pattern.ForwardDeathLetters$;
import org.apache.pekko.pattern.RetrySupport$;
import org.apache.pekko.pattern.internal.BackoffOnStopSupervisor;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class BackoffSupervisor$ {
    public static final BackoffSupervisor$ MODULE$ = new BackoffSupervisor$();

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, SupervisorStrategy$.MODULE$.defaultStrategy());
    }

    public Props props(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, int maxNrOfRetries) {
        SupervisorStrategy supervisorStrategy = SupervisorStrategy$.MODULE$.defaultStrategy();
        SupervisorStrategy supervisionStrategy = supervisorStrategy instanceof OneForOneStrategy ? ((OneForOneStrategy)supervisorStrategy).withMaxNrOfRetries(maxNrOfRetries) : supervisorStrategy;
        return this.propsWithSupervisorStrategy(childProps, childName, minBackoff, maxBackoff, randomFactor, supervisionStrategy);
    }

    public Props props(Props childProps, String childName, Duration minBackoff, Duration maxBackoff, double randomFactor) {
        return this.props(childProps, childName, Duration$.MODULE$.fromNanos(minBackoff.toNanos()), Duration$.MODULE$.fromNanos(maxBackoff.toNanos()), randomFactor);
    }

    public Props props(Props childProps, String childName, Duration minBackoff, Duration maxBackoff, double randomFactor, int maxNrOfRetries) {
        return this.props(childProps, childName, Duration$.MODULE$.fromNanos(minBackoff.toNanos()), Duration$.MODULE$.fromNanos(maxBackoff.toNanos()), randomFactor, maxNrOfRetries);
    }

    /*
     * WARNING - void declaration
     */
    public Props propsWithSupervisorStrategy(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        void apply_creator;
        void apply_evidence$2;
        Predef$.MODULE$.require(minBackoff.$greater((Object)Duration$.MODULE$.Zero()), (Function0 & Serializable)() -> "minBackoff must be > 0");
        Predef$.MODULE$.require(maxBackoff.$greater$eq((Object)minBackoff), (Function0 & Serializable)() -> "maxBackoff must be >= minBackoff");
        Predef$.MODULE$.require(0.0 <= randomFactor && randomFactor <= 1.0, (Function0 & Serializable)() -> "randomFactor must be between 0.0 and 1.0");
        ClassTag classTag = ClassTag$.MODULE$.apply(BackoffOnStopSupervisor.class);
        Function0 & Serializable intersect = (Function0 & Serializable)() -> new BackoffOnStopSupervisor(childProps, childName, minBackoff, maxBackoff, new AutoReset(minBackoff), randomFactor, strategy, ForwardDeathLetters$.MODULE$, (Option<Function1<Object, Object>>)None$.MODULE$);
        Props$ apply_this = Props$.MODULE$;
        Class apply_mkProps_classOfActor = ((ClassTag)Predef$.MODULE$.implicitly((Object)apply_evidence$2)).runtimeClass();
        return apply_this.apply(TypedCreatorFunctionConsumer.class, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{apply_mkProps_classOfActor, apply_creator}));
    }

    public Props propsWithSupervisorStrategy(Props childProps, String childName, Duration minBackoff, Duration maxBackoff, double randomFactor, SupervisorStrategy strategy) {
        return this.propsWithSupervisorStrategy(childProps, childName, Duration$.MODULE$.fromNanos(minBackoff.toNanos()), Duration$.MODULE$.fromNanos(maxBackoff.toNanos()), randomFactor, strategy);
    }

    public Props props(BackoffOptions options) {
        return options.props();
    }

    public Props props(BackoffOnStopOptions options) {
        return options.props();
    }

    public Props props(BackoffOnFailureOptions options) {
        return options.props();
    }

    public BackoffSupervisor$GetCurrentChild$ getCurrentChild() {
        return BackoffSupervisor$GetCurrentChild$.MODULE$;
    }

    public BackoffSupervisor$Reset$ reset() {
        return BackoffSupervisor$Reset$.MODULE$;
    }

    public BackoffSupervisor$GetRestartCount$ getRestartCount() {
        return BackoffSupervisor$GetRestartCount$.MODULE$;
    }

    public FiniteDuration calculateDelay(int restartCount, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        return RetrySupport$.MODULE$.calculateDelay(restartCount, minBackoff, maxBackoff, randomFactor);
    }

    private BackoffSupervisor$() {
    }
}

