/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.InputStream;
import java.util.Objects;
import org.apache.pekko.annotation.InternalApi;

@InternalApi
public class UnsynchronizedByteArrayInputStream
extends InputStream {
    private static final int END_OF_STREAM = -1;
    private final byte[] data;
    private final int eod;
    private int offset;
    private int markedOffset;

    private static int minPosLen(byte[] byArray, int n) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(n, "defaultValue");
        return Math.min(n, byArray.length > 0 ? byArray.length : n);
    }

    private static int requireNonNegative(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException(string + " cannot be negative");
        }
        return n;
    }

    private static void checkFromIndexSize(byte[] byArray, int n, int n2) {
        int n3 = Objects.requireNonNull(byArray, "byte array").length;
        if ((n | n2 | n3) < 0 || n3 - n2 < n) {
            throw new IndexOutOfBoundsException(String.format("Range [%s, %<s + %s) out of bounds for length %s", n, n2, n3));
        }
    }

    public UnsynchronizedByteArrayInputStream(byte[] byArray) {
        this.data = Objects.requireNonNull(byArray, "data");
        this.offset = 0;
        this.markedOffset = 0;
        this.eod = byArray.length;
    }

    public UnsynchronizedByteArrayInputStream(byte[] byArray, int n, int n2) {
        UnsynchronizedByteArrayInputStream.requireNonNegative(n, "offset");
        UnsynchronizedByteArrayInputStream.requireNonNegative(n2, "length");
        this.data = Objects.requireNonNull(byArray, "data");
        this.eod = Math.min(UnsynchronizedByteArrayInputStream.minPosLen(byArray, n) + n2, byArray.length);
        this.offset = UnsynchronizedByteArrayInputStream.minPosLen(byArray, n);
        this.markedOffset = UnsynchronizedByteArrayInputStream.minPosLen(byArray, n);
    }

    @Override
    public int available() {
        return this.offset < this.eod ? this.eod - this.offset : 0;
    }

    @Override
    public void mark(int n) {
        this.markedOffset = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        return this.offset < this.eod ? this.data[this.offset++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray) {
        Objects.requireNonNull(byArray, "dest");
        return this.readLocal(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        UnsynchronizedByteArrayInputStream.checkFromIndexSize(byArray, n, n2);
        return this.readLocal(byArray, n, n2);
    }

    private final int readLocal(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (this.offset >= this.eod) {
            return -1;
        }
        int n3 = this.eod - this.offset;
        if (n2 < n3) {
            n3 = n2;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.data, this.offset, byArray, n, n3);
        this.offset += n3;
        return n3;
    }

    @Override
    public void reset() {
        this.offset = this.markedOffset;
    }

    @Override
    public long skip(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Skipping backward is not supported");
        }
        long l2 = this.eod - this.offset;
        if (l < l2) {
            l2 = l;
        }
        this.offset = Math.addExact(this.offset, Math.toIntExact(l));
        return l2;
    }
}

