/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.artifact.resolution;

import com.xebialabs.deployit.engine.spi.artifact.resolution.ArtifactResolver;
import com.xebialabs.deployit.engine.spi.artifact.resolution.CannotLocateArtifactException;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import java.io.Serializable;
import java.net.URI;
import nl.javadude.scannit.Scannit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ArtifactResolverRegistry$ {
    public static final ArtifactResolverRegistry$ MODULE$ = new ArtifactResolverRegistry$();
    private static Map<String, ArtifactResolver> lookupTable;
    private static final Seq<String> storedArtifactSchemes;
    private static volatile boolean bitmap$0;

    static {
        storedArtifactSchemes = new .colon.colon((Object)"internal", (List)Nil$.MODULE$);
    }

    private Map<String, ArtifactResolver> lookupTable$lzycompute() {
        ArtifactResolverRegistry$ artifactResolverRegistry$ = this;
        synchronized (artifactResolverRegistry$) {
            if (!bitmap$0) {
                lookupTable = this.createLookupTable(Scannit.getInstance());
                bitmap$0 = true;
            }
        }
        return lookupTable;
    }

    private Map<String, ArtifactResolver> lookupTable() {
        if (!bitmap$0) {
            return this.lookupTable$lzycompute();
        }
        return lookupTable;
    }

    private final Seq<String> storedArtifactSchemes() {
        return storedArtifactSchemes;
    }

    public ArtifactResolver lookup(URI location) {
        return (ArtifactResolver)this.lookupTable().getOrElse((Object)location.getScheme(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Can not find a resolver for " + Option$.MODULE$.apply((Object)location.getScheme()).getOrElse((Function0 & Serializable)() -> location.toString()) + ". Supported schemes are: " + MODULE$.lookupTable().keySet().mkString(","));
        });
    }

    public ArtifactResolver lookup(String location2) {
        return (ArtifactResolver)this.withLocation(location2, (Function1 & Serializable)location -> MODULE$.lookup((URI)location));
    }

    public ResolvedArtifactFile resolve(SourceArtifact artifact) {
        return (ResolvedArtifactFile)this.withLocation(artifact.getFileUri(), (Function1 & Serializable)l -> MODULE$.lookup((URI)l).resolveLocation(artifact));
    }

    public boolean validate(SourceArtifact artifact) {
        return BoxesRunTime.unboxToBoolean(this.withLocation(artifact.getFileUri(), (Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)ArtifactResolverRegistry$.$anonfun$validate$1(artifact, uri))));
    }

    public boolean isStoredArtifact(SourceArtifact artifact) {
        return artifact.getFileUri() == null || artifact.getFileUri().isEmpty() || BoxesRunTime.unboxToBoolean(this.withLocation(artifact.getFileUri(), (Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)ArtifactResolverRegistry$.$anonfun$isStoredArtifact$1(uri))));
    }

    public boolean isExternalArtifact(SourceArtifact artifact) {
        return !this.isStoredArtifact(artifact);
    }

    private <T> T withLocation(String location, Function1<URI, T> body) {
        Option option;
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)location).map((Function1 & Serializable)x$1 -> new URI((String)x$1)));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw new CannotLocateArtifactException(e);
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                URI uri = (URI)some.value();
                return (T)body.apply((Object)uri);
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            throw new CannotLocateArtifactException("Passed a 'null' artifact location.");
        }
        throw new MatchError((Object)try_);
    }

    public Map<String, ArtifactResolver> createLookupTable(Scannit scannit) {
        return (Map)CollectionConverters$.MODULE$.SetHasAsScala(scannit.getTypesAnnotatedWith(ArtifactResolver.Resolver.class)).asScala().foldLeft(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(m, c) -> {
            if (!ArtifactResolver.class.isAssignableFrom((Class<?>)c)) {
                throw new IllegalStateException("Class " + c + " annotated with " + ArtifactResolver.Resolver.class + " is not an " + ArtifactResolver.class);
            }
            ArtifactResolver.Resolver resolver = c.getAnnotation(ArtifactResolver.Resolver.class);
            Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])resolver.protocols()), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)m.contains((Object)key)));
            if (option instanceof Some) {
                Some some = (Some)option;
                String protocol = (String)some.value();
                throw new IllegalStateException("Found duplicate artifact resolver for protocol " + protocol);
            }
            if (None$.MODULE$.equals(option)) {
                ArtifactResolver instance = (ArtifactResolver)c.newInstance();
                return (Map)m.$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])resolver.protocols()).toList().map((Function1 & Serializable)x$2 -> new Tuple2(x$2, (Object)instance)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError((Object)option);
        });
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(SourceArtifact artifact$2, URI uri) {
        return MODULE$.lookup(uri).validateCorrectness(artifact$2);
    }

    public static final /* synthetic */ boolean $anonfun$isStoredArtifact$1(URI uri) {
        return MODULE$.storedArtifactSchemes().contains((Object)uri.getScheme());
    }

    private ArtifactResolverRegistry$() {
    }
}

