/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface PermissionEditor {
    public Map<Role, Set<Permission>> readPermissions(String var1, String var2, Paging var3, Ordering var4, Boolean var5);

    default public Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, String rolePattern, Paging paging, Ordering order) {
        return this.readPermissions(onConfigurationItem, rolePattern, paging, order, false);
    }

    default public Map<Role, Set<Permission>> readPermissions(String onConfigurationItem, Boolean includeInherited) {
        return this.readPermissions(onConfigurationItem, null, null, null, includeInherited);
    }

    default public Map<Role, Set<Permission>> readPermissions(String onConfigurationItem) {
        return this.readPermissions(onConfigurationItem, false);
    }

    default public void grant(Role role, Permission permission, String id) {
        Map<Role, Set<Permission>> rolePermissions = this.readPermissions(id);
        rolePermissions.computeIfAbsent(role, r -> new HashSet()).add(permission);
        this.editPermissions(id, rolePermissions);
    }

    default public void revoke(Role role, Permission permission, String id) {
        Map<Role, Set<Permission>> rolePermissions = this.readPermissions(id);
        rolePermissions.computeIfAbsent(role, r -> new HashSet()).remove(permission);
        this.editPermissions(id, rolePermissions);
    }

    public void editPermissions(String var1, Map<Role, Set<Permission>> var2);

    public void updatePermissions(String var1, Map<Role, List<Permission>> var2, Map<Role, List<Permission>> var3);
}

