/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.IllegalUriException$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.parboiled2.CharUtils$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HttpRequest$ {
    public static final HttpRequest$ MODULE$ = new HttpRequest$();

    /*
     * WARNING - void declaration
     */
    public Uri effectiveUri(Uri uri, Seq<HttpHeader> headers2, boolean securedConnection, Host defaultHostHeader) {
        Iterator iterator = headers2.iterator();
        OptionVal$.MODULE$.None();
        Tuple2 tuple2 = this.findHostAndWsUpgrade$1(iterator, null, (Option)None$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Host hostHeader = (Host)((OptionVal)tuple2._1()).x();
        boolean isWebsocket = tuple2._2$mcZ$sp();
        Host hostHeader2 = (Host)new OptionVal((Object)hostHeader).x();
        if (uri.isRelative()) {
            void var12_12;
            void var7_7;
            Host host;
            OptionVal$.MODULE$.None();
            if (hostHeader2 == null) {
                if (defaultHostHeader.isEmpty()) {
                    throw HttpRequest$.fail$1("is missing a `Host` header", uri);
                }
                host = defaultHostHeader;
            } else {
                Host host2 = (Host)OptionVal.Some$.MODULE$.unapply((Object)hostHeader2);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)host2) && ((Host)OptionVal$.MODULE$.get$extension((Object)host2)).isEmpty()) {
                    if (defaultHostHeader.isEmpty()) {
                        throw HttpRequest$.fail$1("an empty `Host` header", uri);
                    }
                    host = defaultHostHeader;
                } else {
                    Host host3 = (Host)OptionVal.Some$.MODULE$.unapply((Object)hostHeader2);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)host3)) {
                        host = (Host)OptionVal$.MODULE$.get$extension((Object)host3);
                    } else {
                        throw new MatchError((Object)new OptionVal((Object)hostHeader2));
                    }
                }
            }
            Host host4 = host;
            if (host4 == null) {
                throw new MatchError(null);
            }
            Uri.Host hostHeaderHost = host4.host();
            int n = host4.port();
            String defaultScheme = var7_7 != false ? Uri$.MODULE$.websocketScheme(securedConnection) : Uri$.MODULE$.httpScheme(securedConnection);
            return uri.toEffectiveRequestUri((Uri.Host)var12_12, n, defaultScheme, Uri$Authority$.MODULE$.Empty());
        }
        if (OptionVal$.MODULE$.isEmpty$extension((Object)hostHeader2) || uri.authority().isEmpty() && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).isEmpty() || ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).host().equalsIgnoreCase(uri.authority().host()) && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).port() == uri.authority().port()) {
            return uri;
        }
        throw IllegalUriException$.MODULE$.apply(new StringBuilder(75).append("'Host' header value of request to `").append(uri).append("` doesn't match request target authority").toString(), new StringBuilder(40).append("Host header: ").append(new OptionVal((Object)hostHeader2)).append("\nrequest target authority: ").append(uri.authority()).toString());
    }

    public void verifyUri(Uri uri) {
        if (uri.isEmpty()) {
            throw IllegalUriException$.MODULE$.apply("`uri` must not be empty", "");
        }
        switch (uri.scheme().length()) {
            case 0: {
                return;
            }
            case 4: {
                if (HttpRequest$.c$1(0, uri) != 'h' || HttpRequest$.c$1(1, uri) != 't' || HttpRequest$.c$1(2, uri) != 't' || HttpRequest$.c$1(3, uri) != 'p') break;
                return;
            }
            case 5: {
                if (HttpRequest$.c$1(0, uri) != 'h' || HttpRequest$.c$1(1, uri) != 't' || HttpRequest$.c$1(2, uri) != 't' || HttpRequest$.c$1(3, uri) != 'p' || HttpRequest$.c$1(4, uri) != 's') break;
                return;
            }
            case 2: {
                if (HttpRequest$.c$1(0, uri) != 'w' || HttpRequest$.c$1(1, uri) != 's') break;
                return;
            }
            case 3: {
                if (HttpRequest$.c$1(0, uri) != 'w' || HttpRequest$.c$1(1, uri) != 's' || HttpRequest$.c$1(2, uri) != 's') break;
                return;
            }
        }
        throw IllegalUriException$.MODULE$.apply("`uri` must have scheme \"http\", \"https\", \"ws\", \"wss\" or no scheme", "");
    }

    public HttpRequest apply(HttpMethod method, Uri uri, Seq<HttpHeader> headers2, RequestEntity entity, HttpProtocol protocol) {
        return new HttpRequest(method, uri, headers2, Predef$.MODULE$.Map().empty(), entity, protocol);
    }

    public HttpMethod apply$default$1() {
        return HttpMethods$.MODULE$.GET();
    }

    public Uri apply$default$2() {
        return Uri$.MODULE$.$div();
    }

    public Seq<HttpHeader> apply$default$3() {
        return Nil$.MODULE$;
    }

    public RequestEntity apply$default$4() {
        return HttpEntity$.MODULE$.Empty();
    }

    public HttpProtocol apply$default$5() {
        return HttpProtocols$.MODULE$.HTTP$div1$u002E1();
    }

    public HttpRequest unapply(HttpRequest any) {
        return any;
    }

    private final Tuple2 findHostAndWsUpgrade$1(Iterator it, Host host, Option wsUpgrade) {
        while (!(OptionVal$.MODULE$.isDefined$extension((Object)host) && wsUpgrade.isDefined() || !it.hasNext())) {
            HttpHeader httpHeader = (HttpHeader)it.next();
            if (httpHeader instanceof Host) {
                Host host2 = (Host)httpHeader;
                host = (Host)OptionVal.Some$.MODULE$.apply((Object)host2);
                continue;
            }
            if (!(httpHeader instanceof Upgrade)) continue;
            Upgrade upgrade = (Upgrade)httpHeader;
            wsUpgrade = new Some((Object)BoxesRunTime.boxToBoolean((boolean)upgrade.hasWebSocket()));
        }
        return new Tuple2((Object)new OptionVal((Object)host), (Object)BoxesRunTime.boxToBoolean((boolean)wsUpgrade.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))));
    }

    private static final Host findHostAndWsUpgrade$default$2$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final Option findHostAndWsUpgrade$default$3$1() {
        return None$.MODULE$;
    }

    private static final Nothing$ fail$1(String detail, Uri uri$1) {
        throw IllegalUriException$.MODULE$.apply(new StringBuilder(80).append("Cannot establish effective URI of request to `").append(uri$1).append("`, request has a relative URI and ").append(detail).toString(), "consider setting `pekko.http.server.default-host-header`");
    }

    private static final char c$1(int i, Uri uri$2) {
        return CharUtils$.MODULE$.toLowerCase(uri$2.scheme().charAt(i));
    }

    private HttpRequest$() {
    }
}

