/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.security.mac;

import com.hierynomus.security.Mac;
import com.hierynomus.security.MessageDigest;
import com.hierynomus.security.SecurityException;

public class HmacT64
implements Mac {
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private MessageDigest md5;
    private byte[] ipad = new byte[64];
    private byte[] opad = new byte[64];

    public HmacT64(MessageDigest md5) {
        this.md5 = md5;
    }

    @Override
    public void init(byte[] key) throws SecurityException {
        int i;
        if (key == null) {
            throw new SecurityException("Missing key data");
        }
        int length = Math.min(key.length, 64);
        for (i = 0; i < length; ++i) {
            this.ipad[i] = (byte)(key[i] ^ 0x36);
            this.opad[i] = (byte)(key[i] ^ 0x5C);
        }
        for (i = length; i < 64; ++i) {
            this.ipad[i] = 54;
            this.opad[i] = 92;
        }
        this.reset();
    }

    @Override
    public byte[] doFinal() {
        try {
            byte[] tmp = this.md5.digest();
            this.md5.update(this.opad);
            this.md5.update(tmp);
            byte[] byArray = tmp = this.md5.digest();
            return byArray;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void update(byte b) {
        this.md5.update(b);
    }

    @Override
    public void update(byte[] array) {
        this.md5.update(array);
    }

    @Override
    public void update(byte[] array, int offset, int length) {
        this.md5.update(array, offset, length);
    }

    @Override
    public void reset() {
        this.md5.reset();
        this.md5.update(this.ipad, 0, this.ipad.length);
    }
}

