/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.messages;

import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.ntlm.messages.NtlmMessage;
import com.hierynomus.ntlm.messages.NtlmNegotiateFlag;
import com.hierynomus.ntlm.messages.Utils;
import com.hierynomus.ntlm.messages.WindowsVersion;
import com.hierynomus.protocol.commons.ByteArrayUtils;
import com.hierynomus.protocol.commons.Charsets;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import java.util.Set;

public class NtlmAuthenticate
extends NtlmMessage {
    private byte[] lmResponse;
    private byte[] ntResponse;
    private byte[] userName;
    private byte[] domainName;
    private byte[] workstation;
    private byte[] encryptedRandomSessionKey;
    private byte[] mic;

    public NtlmAuthenticate(byte[] lmResponse, byte[] ntResponse, String userName, String domainName, String workstation, byte[] encryptedRandomSessionKey, Set<NtlmNegotiateFlag> negotiateFlags, WindowsVersion version) {
        super(negotiateFlags, version);
        this.lmResponse = Utils.ensureNotNull(lmResponse);
        this.ntResponse = Utils.ensureNotNull(ntResponse);
        this.userName = Utils.ensureNotNull(userName);
        this.domainName = Utils.ensureNotNull(domainName);
        this.workstation = Utils.ensureNotNull(workstation);
        this.encryptedRandomSessionKey = Utils.ensureNotNull(encryptedRandomSessionKey);
        this.negotiateFlags = negotiateFlags;
    }

    private int getBaseMessageSize() {
        int baseMessageSize = 64;
        if (this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_VERSION) || this.mic != null) {
            baseMessageSize += 8;
        }
        if (this.mic != null) {
            baseMessageSize += 16;
        }
        return baseMessageSize;
    }

    @Override
    public void write(Buffer.PlainBuffer buffer) {
        buffer.putString("NTLMSSP\u0000", Charsets.UTF_8);
        buffer.putUInt32(3L);
        int offset = this.getBaseMessageSize();
        offset = Utils.writeOffsettedByteArrayFields(buffer, this.lmResponse, offset);
        offset = Utils.writeOffsettedByteArrayFields(buffer, this.ntResponse, offset);
        offset = Utils.writeOffsettedByteArrayFields(buffer, this.domainName, offset);
        offset = Utils.writeOffsettedByteArrayFields(buffer, this.userName, offset);
        offset = Utils.writeOffsettedByteArrayFields(buffer, this.workstation, offset);
        offset = Utils.writeOffsettedByteArrayFields(buffer, this.encryptedRandomSessionKey, offset);
        buffer.putUInt32(EnumWithValue.EnumUtils.toLong(this.negotiateFlags));
        if (this.negotiateFlags.contains(NtlmNegotiateFlag.NTLMSSP_NEGOTIATE_VERSION)) {
            buffer.putRawBytes(this.getVersion());
        } else if (this.mic != null) {
            buffer.putUInt64(0L);
        }
        if (this.mic != null) {
            buffer.putRawBytes(this.mic, 0, 16);
        }
        buffer.putRawBytes(this.lmResponse);
        buffer.putRawBytes(this.ntResponse);
        buffer.putRawBytes(this.domainName);
        buffer.putRawBytes(this.userName);
        buffer.putRawBytes(this.workstation);
        buffer.putRawBytes(this.encryptedRandomSessionKey);
    }

    public void setMic(byte[] mic) {
        this.mic = mic;
    }

    public byte[] getVersion() {
        Buffer.PlainBuffer plainBuffer = new Buffer.PlainBuffer(Endian.LE);
        plainBuffer.putByte((byte)6);
        plainBuffer.putByte((byte)1);
        plainBuffer.putUInt16(7600);
        byte[] reserved = new byte[]{0, 0, 0};
        plainBuffer.putRawBytes(reserved);
        plainBuffer.putByte((byte)15);
        return plainBuffer.getCompactData();
    }

    public String toString() {
        return "NtlmAuthenticate{\n  mic=" + (this.mic != null ? ByteArrayUtils.printHex(this.mic) : "[]") + ",\n  lmResponse=" + ByteArrayUtils.printHex(this.lmResponse) + ",\n  ntResponse=" + ByteArrayUtils.printHex(this.ntResponse) + ",\n  domainName='" + NtlmFunctions.unicode(this.domainName) + "',\n  userName='" + NtlmFunctions.unicode(this.userName) + "',\n  workstation='" + NtlmFunctions.unicode(this.workstation) + "',\n  encryptedRandomSessionKey=[<secret>],\n" + '}';
    }
}

