/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.ByteArrayFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverthereUtils {
    private static final Logger logger = LoggerFactory.getLogger(OverthereUtils.class);

    public static byte[] read(OverthereFile from) {
        InputStream is = from.getInputStream();
        try {
            int nRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((nRead = is.read(bytes, 0, bytes.length)) != -1) {
                os.write(bytes, 0, nRead);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            OverthereUtils.closeQuietly(is);
        }
    }

    public static String read(OverthereFile from, String charsetName) {
        InputStream is = from.getInputStream();
        try {
            int nRead;
            InputStreamReader isr = new InputStreamReader(is, charsetName);
            StringBuilder b = new StringBuilder();
            char[] chars = new char[1024];
            while ((nRead = isr.read(chars, 0, chars.length)) != -1) {
                b.append(chars, 0, nRead);
            }
            String string = b.toString();
            return string;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            OverthereUtils.closeQuietly(is);
        }
    }

    public static void write(byte[] from, OverthereFile to) {
        new ByteArrayFile(to.getPath(), from).copyTo(to);
    }

    public static void write(InputStream from, OverthereFile to) {
        OutputStream toStream = to.getOutputStream();
        try {
            OverthereUtils.write(from, toStream);
        }
        finally {
            OverthereUtils.closeQuietly(toStream);
        }
    }

    public static void write(InputStream from, OutputStream to) {
        try {
            int nRead;
            byte[] bytes = new byte[1024];
            while ((nRead = from.read(bytes, 0, bytes.length)) != -1) {
                to.write(bytes, 0, nRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static void write(Reader from, Writer to) {
        try {
            int nRead;
            char[] chars = new char[1024];
            while ((nRead = from.read(chars, 0, chars.length)) != -1) {
                to.write(chars, 0, nRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static void write(String from, String charsetName, OverthereFile to) {
        try {
            OverthereUtils.write(from.getBytes(charsetName), to);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException("Cannot write string to " + String.valueOf(to), exc);
        }
    }

    public static String getName(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return path.substring(lastSlash + 1);
        }
        int lastBackslash = path.lastIndexOf(92);
        if (lastBackslash >= 0) {
            return path.substring(lastBackslash + 1);
        }
        return path;
    }

    public static String getBaseName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(0, dot);
        }
        return name;
    }

    public static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(dot);
        }
        return "";
    }

    public static String constructPath(OverthereFile parent, String child) {
        return parent.getPath() + parent.getConnection().getHostOperatingSystem().getFileSeparator() + child;
    }

    public static void closeQuietly(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            logger.warn("IOException while closing closeable", (Throwable)e);
        }
    }

    public static void checkArgument(boolean expression, String errorMessage, Object ... messageParams) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessage, messageParams));
        }
    }

    public static void checkState(boolean expression, String errorMessage, Object ... messageParams) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessage, messageParams));
        }
    }

    public static <T> T checkNotNull(T t, String errorMessage, Object ... messageParams) {
        if (t == null) {
            throw new NullPointerException(String.format(errorMessage, messageParams));
        }
        return t;
    }

    public static String mkString(List<String> strings, char sep) {
        return OverthereUtils.mkString(strings, String.valueOf(sep));
    }

    public static String mkString(List<String> strings, String sep) {
        if (strings.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder(strings.get(0));
        for (int i = 1; i < strings.size(); ++i) {
            b.append(sep).append(strings.get(i));
        }
        return b.toString();
    }

    public static OverthereFile getUniqueFolder(OverthereFile baseDir) {
        String temporaryFileHolderDirectoryNamePrefix = "ot-" + new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS").format(new Date());
        return OverthereUtils.getUniqueFolder(baseDir, temporaryFileHolderDirectoryNamePrefix);
    }

    public static OverthereFile getUniqueFolder(OverthereFile baseDir, String directoryNameBase) {
        ConnectionOptions options = baseDir.getConnection().getOptions();
        int temporaryFileCreationRetries = options.getInteger("tmpFileCreationRetries", 100);
        if (!baseDir.exists()) {
            throw new RuntimeIOException("Cannot create unique directory in non existing basedir " + String.valueOf(baseDir));
        }
        RuntimeException originalExc = null;
        int salt = new Random().nextInt(10000);
        for (int i = 0; i <= temporaryFileCreationRetries; ++i) {
            OverthereFile holder;
            if (!(holder = baseDir.getFile(directoryNameBase + "." + ++salt)).exists()) {
                logger.trace("Creating unique directory {}", (Object)holder);
                try {
                    holder.mkdir();
                    return holder;
                }
                catch (RuntimeException exc) {
                    originalExc = exc;
                    logger.debug(String.format("Failed to create holder directory %s - Trying with the next suffix", holder), (Throwable)exc);
                    continue;
                }
            }
            logger.trace("Could not create new unique directory '{}' as it exists already.'", (Object)holder);
        }
        String errorText = "Cannot generate a unique directory on " + String.valueOf(baseDir);
        if (originalExc != null) {
            throw new RuntimeIOException(errorText, originalExc);
        }
        throw new RuntimeIOException(errorText);
    }
}

