/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.keepalive;

import java.util.LinkedList;
import java.util.Queue;
import net.schmizz.concurrent.Promise;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.transport.TransportException;

public class KeepAliveRunner
extends KeepAlive {
    private int maxAliveCount = 5;
    private final Queue<Promise<SSHPacket, ConnectionException>> queue = new LinkedList<Promise<SSHPacket, ConnectionException>>();

    KeepAliveRunner(ConnectionImpl conn) {
        super(conn, "sshj-KeepAliveRunner");
    }

    public synchronized int getMaxAliveCount() {
        return this.maxAliveCount;
    }

    public synchronized void setMaxAliveCount(int maxAliveCount) {
        this.maxAliveCount = maxAliveCount;
    }

    @Override
    protected void doKeepAlive() throws TransportException, ConnectionException {
        if (this.conn.equals(this.conn.getTransport().getService())) {
            this.emptyQueue(this.queue);
            this.checkMaxReached(this.queue);
            this.queue.add(this.conn.sendGlobalRequest("keepalive@openssh.com", true, new byte[0]));
        }
    }

    private void checkMaxReached(Queue<Promise<SSHPacket, ConnectionException>> queue) throws ConnectionException {
        if (queue.size() >= this.maxAliveCount) {
            throw new ConnectionException(DisconnectReason.CONNECTION_LOST, String.format("Did not receive any keep-alive response for %s seconds", this.maxAliveCount * this.keepAliveInterval));
        }
    }

    private void emptyQueue(Queue<Promise<SSHPacket, ConnectionException>> queue) {
        Promise<SSHPacket, ConnectionException> peek = queue.peek();
        while (peek != null && peek.isFulfilled()) {
            this.log.debug("Received response from server to our keep-alive.");
            queue.remove();
            peek = queue.peek();
        }
    }
}

