/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.Logging;
import org.apache.pekko.http.javadsl.HandlerProvider;
import org.apache.pekko.http.javadsl.Http;
import org.apache.pekko.http.javadsl.ServerBinding;
import org.apache.pekko.http.javadsl.server.AllDirectives;
import org.apache.pekko.http.javadsl.server.Route;
import org.apache.pekko.http.javadsl.settings.ServerSettings;

@Deprecated
public abstract class HttpApp
extends AllDirectives {
    private AtomicReference<ServerBinding> serverBinding = new AtomicReference();
    protected AtomicReference<ActorSystem> systemReference = new AtomicReference();

    public void startServer(String string, int n) throws ExecutionException, InterruptedException {
        this.startServer(string, n, ServerSettings.create((Config)ConfigFactory.load()));
    }

    public void startServer(String string, int n, ActorSystem actorSystem) throws ExecutionException, InterruptedException {
        this.startServer(string, n, ServerSettings.create((ActorSystem)actorSystem), Optional.ofNullable(actorSystem));
    }

    public void startServer(String string, int n, ServerSettings serverSettings) throws ExecutionException, InterruptedException {
        this.startServer(string, n, serverSettings, Optional.empty());
    }

    public void startServer(String string, int n, ServerSettings serverSettings, ActorSystem actorSystem) throws ExecutionException, InterruptedException {
        this.startServer(string, n, serverSettings, Optional.ofNullable(actorSystem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(String string, int n, ServerSettings serverSettings, Optional<ActorSystem> optional) throws ExecutionException, InterruptedException {
        ActorSystem actorSystem = optional.orElseGet(() -> ActorSystem.create((String)Logging.simpleName((Object)this).replaceAll("\\$", "")));
        this.systemReference.set(actorSystem);
        CompletionStage completionStage = Http.get((ActorSystem)actorSystem).newServerAt(string, n).withSettings(serverSettings).bind((HandlerProvider)this.routes());
        completionStage.handle((? super T serverBinding, Throwable throwable) -> {
            if (throwable != null) {
                this.postHttpBindingFailure((Throwable)throwable);
            } else {
                this.serverBinding.set((ServerBinding)serverBinding);
                this.postHttpBinding((ServerBinding)serverBinding);
            }
            return null;
        });
        try {
            ((CompletableFuture)completionStage.thenCompose(serverBinding -> this.waitForShutdownSignal(actorSystem)).toCompletableFuture().exceptionally(throwable -> Done.getInstance())).get();
        }
        finally {
            completionStage.thenCompose(ServerBinding::unbind).handle((? super T done, Throwable throwable) -> {
                this.postServerShutdown(Optional.ofNullable(throwable), actorSystem);
                if (!optional.isPresent()) {
                    actorSystem.terminate();
                }
                return null;
            });
        }
    }

    ServerBinding binding() {
        if (this.serverBinding.get() == null) {
            throw new IllegalStateException("Binding not yet stored. Have you called startServer?");
        }
        return this.serverBinding.get();
    }

    protected void postServerShutdown(Optional<Throwable> optional, ActorSystem actorSystem) {
        this.systemReference.get().log().info("Shutting down the server");
    }

    protected void postHttpBinding(ServerBinding serverBinding) {
        this.systemReference.get().log().info("Server online at http://" + serverBinding.localAddress().getHostName() + ":" + serverBinding.localAddress().getPort() + "/");
    }

    protected void postHttpBindingFailure(Throwable throwable) {
        this.systemReference.get().log().error(throwable, "Error starting the server: " + throwable.getMessage());
    }

    protected CompletionStage<Done> waitForShutdownSignal(ActorSystem actorSystem) {
        CompletableFuture<Done> completableFuture = new CompletableFuture<Done>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> completableFuture.complete(Done.getInstance())));
        CompletableFuture.runAsync(() -> {
            System.out.println("Press RETURN to stop...");
            try {
                if (System.in.read() >= 0) {
                    completableFuture.complete(Done.getInstance());
                }
            }
            catch (IOException iOException) {
                this.systemReference.get().log().error((Throwable)iOException, "Problem occurred! " + iOException.getMessage());
            }
        });
        return completableFuture;
    }

    protected abstract Route routes();
}

