/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PySystemState;
import org.python.core.packagecache.PathPackageManager;

public class SysPackageManager
extends PathPackageManager {
    private static Logger pkglog = Logger.getLogger("org.python.package");

    @Override
    protected void message(String msg, Object ... params) {
        pkglog.log(Level.INFO, msg, params);
    }

    @Override
    protected void warning(String msg, Object ... params) {
        pkglog.log(Level.WARNING, msg, params);
    }

    @Override
    protected void comment(String msg, Object ... params) {
        pkglog.log(Level.CONFIG, msg, params);
    }

    @Override
    protected void debug(String msg, Object ... params) {
        pkglog.log(Level.FINE, msg, params);
    }

    public SysPackageManager(File cachedir, Properties registry) {
        if (this.useCacheDir(cachedir)) {
            this.initCache();
            this.findAllPackages(registry);
            this.saveCache();
        }
    }

    @Override
    public void addJar(String jarfile, boolean cache) {
        this.addJarToPackages(new File(jarfile), cache);
        if (cache) {
            this.saveCache();
        }
    }

    @Override
    public void addJarDir(String jdir, boolean cache) {
        this.addJarDir(jdir, cache, cache);
    }

    private void addJarDir(String jdir, boolean cache, boolean saveCache) {
        File file = new File(jdir);
        String[] files = file.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String entry = files[i];
                if (!entry.endsWith(".jar") && !entry.endsWith(".zip")) continue;
                this.addJarToPackages(new File(jdir, entry), cache);
            }
            if (saveCache) {
                this.saveCache();
            }
        }
    }

    private void addJarPath(String path) {
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String entry = tok.nextToken();
            this.addJarDir(entry, true, false);
        }
    }

    private void addModuleDir(final Path moduleDir) {
        try {
            SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (!dir.equals(moduleDir) && Files.exists(dir.resolve("module-info.class"), new LinkOption[0])) {
                        SysPackageManager.this.addModuleToPackages(dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(moduleDir, (FileVisitor<? super Path>)visitor2);
        }
        catch (IOException e) {
            this.warning("error enumerating Java modules in {0}: {1}", moduleDir, e.getMessage());
        }
    }

    private void findAllPackages(Properties registry) {
        String defaultDirectories;
        String defaultClassPaths;
        try {
            FileSystem jrtfs = FileSystems.getFileSystem(URI.create("jrt:/"));
            this.addModuleDir(jrtfs.getPath("/modules/", new String[0]));
            defaultClassPaths = "java.class.path";
            defaultDirectories = "";
        }
        catch (ProviderNotFoundException e) {
            defaultClassPaths = "java.class.path,sun.boot.class.path";
            defaultDirectories = "java.ext.dirs";
        }
        Set<String> cps = SysPackageManager.split(registry.getProperty("python.packages.paths", defaultClassPaths));
        for (String string2 : cps) {
            String classPath = registry.getProperty(string2);
            if (classPath == null) continue;
            this.addClassPath(classPath);
        }
        Set<String> directories = SysPackageManager.split(registry.getProperty("python.packages.directories", defaultDirectories));
        for (String name : directories) {
            String path = registry.getProperty(name);
            if (path == null) continue;
            this.addJarPath(path);
        }
        String string3 = registry.getProperty("python.packages.fakepath", null);
        if (string3 != null) {
            this.addClassPath(string3);
        }
    }

    @Override
    public void notifyPackageImport(String pkg, String name) {
        if (pkg != null && pkg.length() > 0) {
            this.comment("import {0} # as java package {1}.{0}", name);
        } else {
            this.comment("import {0} # as java package", name);
        }
    }

    @Override
    public Class findClass(String pkg, String name) {
        Class c = super.findClass(pkg, name);
        if (c != null) {
            this.comment("import {0} # as java class", name);
        }
        return c;
    }

    @Override
    public Class findClass(String pkg, String name, String reason) {
        if (pkg != null && pkg.length() > 0) {
            name = pkg + '.' + name;
        }
        return Py.findClassEx(name, reason);
    }

    @Override
    public PyList doDir(PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        PyList basic = this.basicDoDir(jpkg, instantiate, exclpkgs);
        PyList ret = new PyList();
        this.doDir(this.searchPath, ret, jpkg, instantiate, exclpkgs);
        PySystemState sys = Py.getSystemState();
        if (sys.getClassLoader() == null) {
            this.doDir(sys.path, ret, jpkg, instantiate, exclpkgs);
        }
        return this.merge(basic, ret);
    }

    @Override
    public boolean packageExists(String pkg, String name) {
        if (SysPackageManager.packageExists(this.searchPath, pkg, name)) {
            return true;
        }
        PySystemState sys = Py.getSystemState();
        return sys.getClassLoader() == null && SysPackageManager.packageExists(sys.path, pkg, name);
    }
}

