/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.signers;

import org.python.bouncycastle.crypto.CipherParameters;
import org.python.bouncycastle.crypto.CryptoServiceProperties;
import org.python.bouncycastle.crypto.CryptoServicePurpose;
import org.python.bouncycastle.crypto.constraints.ConstraintUtils;
import org.python.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.python.bouncycastle.crypto.params.DSAKeyParameters;
import org.python.bouncycastle.crypto.params.ECKeyParameters;
import org.python.bouncycastle.crypto.params.GOST3410KeyParameters;

class Utils {
    Utils() {
    }

    static CryptoServiceProperties getDefaultProperties(String string2, DSAKeyParameters dSAKeyParameters, boolean bl) {
        return new DefaultServiceProperties(string2, ConstraintUtils.bitsOfSecurityFor(dSAKeyParameters.getParameters().getP()), dSAKeyParameters, Utils.getPurpose(bl));
    }

    static CryptoServiceProperties getDefaultProperties(String string2, GOST3410KeyParameters gOST3410KeyParameters, boolean bl) {
        return new DefaultServiceProperties(string2, ConstraintUtils.bitsOfSecurityFor(gOST3410KeyParameters.getParameters().getP()), gOST3410KeyParameters, Utils.getPurpose(bl));
    }

    static CryptoServiceProperties getDefaultProperties(String string2, ECKeyParameters eCKeyParameters, boolean bl) {
        return new DefaultServiceProperties(string2, ConstraintUtils.bitsOfSecurityFor(eCKeyParameters.getParameters().getCurve()), eCKeyParameters, Utils.getPurpose(bl));
    }

    static CryptoServiceProperties getDefaultProperties(String string2, int n, CipherParameters cipherParameters, boolean bl) {
        return new DefaultServiceProperties(string2, n, cipherParameters, Utils.getPurpose(bl));
    }

    static CryptoServicePurpose getPurpose(boolean bl) {
        return bl ? CryptoServicePurpose.SIGNING : CryptoServicePurpose.VERIFYING;
    }
}

