/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.agreement;

import org.python.bouncycastle.crypto.CryptoServiceProperties;
import org.python.bouncycastle.crypto.CryptoServicePurpose;
import org.python.bouncycastle.crypto.constraints.ConstraintUtils;
import org.python.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.python.bouncycastle.crypto.params.DHKeyParameters;
import org.python.bouncycastle.crypto.params.ECKeyParameters;
import org.python.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.python.bouncycastle.crypto.params.X448PrivateKeyParameters;

class Utils {
    Utils() {
    }

    static CryptoServiceProperties getDefaultProperties(String string2, ECKeyParameters eCKeyParameters) {
        return new DefaultServiceProperties(string2, ConstraintUtils.bitsOfSecurityFor(eCKeyParameters.getParameters().getCurve()), eCKeyParameters, CryptoServicePurpose.AGREEMENT);
    }

    static CryptoServiceProperties getDefaultProperties(String string2, DHKeyParameters dHKeyParameters) {
        return new DefaultServiceProperties(string2, ConstraintUtils.bitsOfSecurityFor(dHKeyParameters.getParameters().getP()), dHKeyParameters, CryptoServicePurpose.AGREEMENT);
    }

    static CryptoServiceProperties getDefaultProperties(String string2, X448PrivateKeyParameters x448PrivateKeyParameters) {
        return new DefaultServiceProperties(string2, 224, x448PrivateKeyParameters, CryptoServicePurpose.AGREEMENT);
    }

    static CryptoServiceProperties getDefaultProperties(String string2, X25519PrivateKeyParameters x25519PrivateKeyParameters) {
        return new DefaultServiceProperties(string2, 128, x25519PrivateKeyParameters, CryptoServicePurpose.AGREEMENT);
    }
}

