/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

public class UnixCommandLineArgsSanitizer {
    private static final char[] UNIX_SHELL_CHARS = " \"';{}()&$\\|*?><\n\r\t".toCharArray();

    public static String sanitize(String str) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            for (char character : UNIX_SHELL_CHARS) {
                if (character != c) continue;
                builder.append('\\');
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean containsAnySpecialChars(String str) {
        for (char c : UNIX_SHELL_CHARS) {
            if (str.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }
}

