/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.gcp.GcpKeyManagementType;
import com.xebialabs.overthere.gcp.GcpKeyManager;
import com.xebialabs.overthere.gcp.GenerateSshKey;
import com.xebialabs.overthere.gcp.JCraftGenerateSshKey;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialsType;
import java.util.Map;
import java.util.WeakHashMap;

public class GcpKeyManagerFactory {
    private static final Map<String, GcpKeyManager> managers = new WeakHashMap<String, GcpKeyManager>();
    static final GenerateSshKey GENERATE_SSH_KEY = new JCraftGenerateSshKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcpKeyManager create(ConnectionOptions options) {
        GcpCredentialsType gcpCredentialsType = GcpCredentialsType.resolve(options);
        String managersKey = gcpCredentialsType.createKey(options);
        Map<String, GcpKeyManager> map = managers;
        synchronized (map) {
            GcpKeyManager gcpKeyManager = managers.get(managersKey);
            if (gcpKeyManager == null) {
                GcpCredentialFactory gcpCredentialFactory = gcpCredentialsType.createGcpCredentialFactory(options);
                gcpKeyManager = GcpKeyManagementType.resolveGcpKeyManager(options, gcpCredentialFactory);
                managers.put(managersKey, gcpKeyManager);
            }
            return gcpKeyManager;
        }
    }
}

